"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.CodeEditorField = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _react = _interopRequireDefault(require("react"));
var _uiTheme = require("@kbn/ui-theme");
var _eui = require("@elastic/eui");
var _code_editor = require("./code_editor");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

/**
 * Renders a Monaco code editor in the same style as other EUI form fields.
 */
const CodeEditorField = props => {
  const {
    width,
    height,
    options,
    fullWidth,
    useDarkTheme
  } = props;
  const theme = useDarkTheme ? _uiTheme.euiDarkVars : _uiTheme.euiLightVars;
  const style = {
    width,
    height,
    backgroundColor: options !== null && options !== void 0 && options.readOnly ? theme.euiFormBackgroundReadOnlyColor : theme.euiFormBackgroundColor
  };
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFormControlLayout, {
    append: /*#__PURE__*/_react.default.createElement("div", {
      hidden: true
    }),
    style: style,
    readOnly: options === null || options === void 0 ? void 0 : options.readOnly,
    fullWidth: fullWidth
  }, /*#__PURE__*/_react.default.createElement(_code_editor.CodeEditor, (0, _extends2.default)({}, props, {
    transparentBackground: true
  })));
};
exports.CodeEditorField = CodeEditorField;