"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.uiMetricService = exports.UiMetricService = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _analytics = require("@kbn/analytics");
var _constants = require("../constants");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

class UiMetricService {
  constructor() {
    (0, _defineProperty2.default)(this, "usageCollection", void 0);
  }
  setup(usageCollection) {
    this.usageCollection = usageCollection;
  }
  track(name) {
    if (!this.usageCollection) {
      // Usage collection is an optional plugin and might be disabled
      return;
    }
    const {
      reportUiCounter
    } = this.usageCollection;
    reportUiCounter(_constants.UIM_APP_NAME, _analytics.METRIC_TYPE.COUNT, name);
  }
  trackUiMetric(eventName) {
    return this.track(eventName);
  }
}
exports.UiMetricService = UiMetricService;
const uiMetricService = new UiMetricService();
exports.uiMetricService = uiMetricService;