"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.toKnownError = void 0;
var t = _interopRequireWildcard(require("io-ts"));
var _function = require("fp-ts/lib/function");
var _Either = require("fp-ts/lib/Either");
var _i18n_texts = require("./i18n_texts");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

// This is a runtime type (RT) for an error node which is a recursive type
const errorNodeRT = t.recursion('ErrorNode', ErrorNode => t.intersection([t.interface({
  reason: t.string
}), t.partial({
  processor_type: t.string,
  suppressed: t.array(ErrorNode)
})]));

// This is a runtime type for the attributes object we expect to receive from the server
// for processor errors
const errorAttributesObjectRT = t.interface({
  attributes: t.interface({
    error: t.interface({
      root_cause: t.array(errorNodeRT)
    })
  })
});
const isProcessorsError = (0, _function.flow)(errorAttributesObjectRT.decode, _Either.isRight);
const flattenErrorsTree = node => {
  const result = [];
  const recurse = _node => {
    result.push({
      reason: _node.reason,
      processorType: _node.processor_type
    });
    if (_node.suppressed && Array.isArray(_node.suppressed)) {
      _node.suppressed.forEach(recurse);
    }
  };
  recurse(node);
  return result;
};
const toKnownError = error => {
  if (typeof error === 'object' && error != null && isProcessorsError(error)) {
    const errorAttributes = error;
    const rootCause = errorAttributes.attributes.error.root_cause[0];
    return {
      errors: flattenErrorsTree(rootCause)
    };
  }
  if (typeof error === 'string') {
    return {
      errors: [{
        reason: error
      }]
    };
  }
  if (error instanceof Error || typeof error === 'object' && error != null && error.message) {
    return {
      errors: [{
        reason: error.message
      }]
    };
  }
  return {
    errors: [{
      reason: _i18n_texts.i18nTexts.errors.unknownError
    }]
  };
};
exports.toKnownError = toKnownError;