"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.Reroute = void 0;
var _react = _interopRequireWildcard(require("react"));
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _eui = require("@elastic/eui");
var _shared_imports = require("../../../../../../shared_imports");
var _shared = require("./shared");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const {
  maxLengthField
} = _shared_imports.fieldValidators;
const MAX_DATASET_LENGTH = 100;
const MAX_NAMESPACE_LENGTH = 100;
const fieldsConfig = {
  /* Optional field configs */
  destination: {
    type: _shared_imports.FIELD_TYPES.TEXT,
    serializer: _shared.from.emptyStringToUndefined,
    label: _i18n.i18n.translate('xpack.ingestPipelines.pipelineEditor.reroute.destinationFieldLabel', {
      defaultMessage: 'Destination (optional)'
    }),
    helpText: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.ingestPipelines.pipelineEditor.reroute.destinationFieldHelperText",
      defaultMessage: "A static value for the target. Cannot be set when {dataset} or {namespace} is set.",
      values: {
        dataset: /*#__PURE__*/_react.default.createElement(_eui.EuiCode, null, 'dataset'),
        namespace: /*#__PURE__*/_react.default.createElement(_eui.EuiCode, null, 'namespace')
      }
    })
  },
  dataset: {
    defaultValue: null,
    type: _shared_imports.FIELD_TYPES.COMBO_BOX,
    deserializer: _shared.to.arrayOfStrings,
    serializer: _shared.from.optionalArrayOfStrings,
    label: _i18n.i18n.translate('xpack.ingestPipelines.pipelineEditor.reroute.datasetFieldLabel', {
      defaultMessage: 'Dataset (optional)'
    }),
    helpText: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.ingestPipelines.pipelineEditor.reroute.datasetFieldHelperText",
      defaultMessage: "Field references or a static value for the dataset part of the data stream name. In addition to the criteria for index names, cannot contain {dash} and must be no longer than 100 characters. Defaults to {defaultValue}.",
      values: {
        dash: /*#__PURE__*/_react.default.createElement(_eui.EuiCode, null, '-'),
        defaultValue: /*#__PURE__*/_react.default.createElement(_eui.EuiCode, null, '{{data_stream.dataset}}')
      }
    }),
    validations: [{
      validator: maxLengthField({
        length: MAX_DATASET_LENGTH,
        message: _i18n.i18n.translate('xpack.ingestPipelines.pipelineEditor.rerouteForm.datasetLengthError', {
          defaultMessage: 'The value must not contain more than 100 characters.'
        })
      })
    }]
  },
  namespace: {
    defaultValue: null,
    type: _shared_imports.FIELD_TYPES.COMBO_BOX,
    deserializer: _shared.to.arrayOfStrings,
    serializer: _shared.from.optionalArrayOfStrings,
    label: _i18n.i18n.translate('xpack.ingestPipelines.pipelineEditor.reroute.namespaceFieldLabel', {
      defaultMessage: 'Namespace (optional)'
    }),
    helpText: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.ingestPipelines.pipelineEditor.reroute.namespaceFieldHelperText",
      defaultMessage: "Field references or a static value for the namespace part of the data stream name. Should meet the criteria for index names and must be no longer than 100 characters. Defaults to {defaultValue}.",
      values: {
        defaultValue: /*#__PURE__*/_react.default.createElement(_eui.EuiCode, null, '{{data_stream.namespace}}')
      }
    }),
    validations: [{
      validator: maxLengthField({
        length: MAX_NAMESPACE_LENGTH,
        message: _i18n.i18n.translate('xpack.ingestPipelines.pipelineEditor.rerouteForm.namespaceLengthError', {
          defaultMessage: 'The value must not contain more than 100 characters.'
        })
      })
    }]
  }
};
const Reroute = () => {
  const form = (0, _shared_imports.useFormContext)();
  const [{
    fields
  }] = (0, _shared_imports.useFormData)({
    watch: ['fields.dataset', 'fields.namespace']
  });
  (0, _react.useEffect)(() => {
    if ((fields === null || fields === void 0 ? void 0 : fields.dataset.length) > 0 || (fields === null || fields === void 0 ? void 0 : fields.namespace.length) > 0) {
      form.setFieldValue('fields.destination', '');
    }
  }, [form, fields]);
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_shared_imports.UseField, {
    "data-test-subj": "destinationField",
    config: fieldsConfig.destination,
    component: _shared_imports.Field,
    componentProps: {
      euiFieldProps: {
        disabled: (fields === null || fields === void 0 ? void 0 : fields.dataset.length) > 0 || (fields === null || fields === void 0 ? void 0 : fields.namespace.length) > 0
      }
    },
    path: "fields.destination"
  }), /*#__PURE__*/_react.default.createElement(_shared_imports.UseField, {
    "data-test-subj": "datasetField",
    config: fieldsConfig.dataset,
    component: _shared_imports.ComboBoxField,
    path: "fields.dataset"
  }), /*#__PURE__*/_react.default.createElement(_shared_imports.UseField, {
    "data-test-subj": "namespaceField",
    config: fieldsConfig.namespace,
    component: _shared_imports.ComboBoxField,
    path: "fields.namespace"
  }));
};
exports.Reroute = Reroute;