"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.NetworkDirection = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _react = _interopRequireWildcard(require("react"));
var _i18n = require("@kbn/i18n");
var _lodash = require("lodash");
var _i18nReact = require("@kbn/i18n-react");
var _eui = require("@elastic/eui");
var _shared_imports = require("../../../../../../shared_imports");
var _shared = require("./shared");
var _target_field = require("./common_fields/target_field");
var _ignore_missing_field = require("./common_fields/ignore_missing_field");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const internalNetworkValues = ['loopback', 'unicast', 'global_unicast', 'multicast', 'interface_local_multicast', 'link_local_unicast', 'link_local_multicast', 'link_local_multicast', 'private', 'public', 'unspecified'];
const fieldsConfig = {
  /* Optional fields config */
  source_ip: {
    type: _shared_imports.FIELD_TYPES.TEXT,
    serializer: _shared.from.emptyStringToUndefined,
    label: _i18n.i18n.translate('xpack.ingestPipelines.pipelineEditor.networkDirection.sourceIpLabel', {
      defaultMessage: 'Source IP (optional)'
    }),
    helpText: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.ingestPipelines.pipelineEditor.networkDirection.sourceIpHelpText",
      defaultMessage: "Field containing the source IP address. Defaults to {defaultField}.",
      values: {
        defaultField: /*#__PURE__*/_react.default.createElement(_eui.EuiCode, null, 'source.ip')
      }
    })
  },
  destination_ip: {
    type: _shared_imports.FIELD_TYPES.TEXT,
    serializer: _shared.from.emptyStringToUndefined,
    label: _i18n.i18n.translate('xpack.ingestPipelines.pipelineEditor.networkDirection.destinationIpLabel', {
      defaultMessage: 'Destination IP (optional)'
    }),
    helpText: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.ingestPipelines.pipelineEditor.networkDirection.destionationIpHelpText",
      defaultMessage: "Field containing the destination IP address. Defaults to {defaultField}.",
      values: {
        defaultField: /*#__PURE__*/_react.default.createElement(_eui.EuiCode, null, 'destination.ip')
      }
    })
  }
};
const getInternalNetworkConfig = toggleCustom => ({
  internal_networks: {
    path: 'fields.internal_networks',
    euiFieldProps: {
      noSuggestions: false,
      options: internalNetworkValues.map(label => ({
        label
      }))
    },
    config: {
      type: _shared_imports.FIELD_TYPES.COMBO_BOX,
      deserializer: _shared.to.arrayOfStrings,
      serializer: _shared.from.optionalArrayOfStrings,
      fieldsToValidateOnChange: ['fields.internal_networks', 'fields.internal_networks_field'],
      validations: [{
        validator: ({
          value,
          path,
          formData
        }) => {
          if ((0, _lodash.isEmpty)(value) && (0, _lodash.isEmpty)(formData['fields.internal_networks_field'])) {
            return {
              path,
              message: 'A field value is required.'
            };
          }
        }
      }],
      label: _i18n.i18n.translate('xpack.ingestPipelines.pipelineEditor.networkDirection.internalNetworksLabel', {
        defaultMessage: 'Internal networks'
      }),
      helpText: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.ingestPipelines.pipelineEditor.networkDirection.internalNetworksHelpText",
        defaultMessage: "List of internal networks."
      })
    },
    labelAppend: /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
      size: "xs"
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
      onClick: toggleCustom,
      "data-test-subj": "toggleCustomField"
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.ingestPipelines.pipelineEditor.internalNetworkCustomLabel",
      defaultMessage: "Use custom field"
    }))),
    key: 'preset'
  },
  internal_networks_field: {
    path: 'fields.internal_networks_field',
    config: {
      type: _shared_imports.FIELD_TYPES.TEXT,
      serializer: _shared.from.emptyStringToUndefined,
      fieldsToValidateOnChange: ['fields.internal_networks', 'fields.internal_networks_field'],
      validations: [{
        validator: ({
          value,
          path,
          formData
        }) => {
          if ((0, _lodash.isEmpty)(value) && (0, _lodash.isEmpty)(formData['fields.internal_networks'])) {
            return {
              path,
              message: 'A field value is required.'
            };
          }
        }
      }],
      label: _i18n.i18n.translate('xpack.ingestPipelines.pipelineEditor.networkDirection.internalNetworksFieldLabel', {
        defaultMessage: 'Internal networks field'
      }),
      helpText: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.ingestPipelines.pipelineEditor.networkDirection.internalNetworksFieldHelpText",
        defaultMessage: "Field stating where to read the {field} configuration from.",
        values: {
          field: /*#__PURE__*/_react.default.createElement(_eui.EuiCode, null, 'internal_networks')
        }
      })
    },
    labelAppend: /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
      size: "xs"
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
      onClick: toggleCustom,
      "data-test-subj": "toggleCustomField"
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.ingestPipelines.pipelineEditor.internalNetworkPredefinedLabel",
      defaultMessage: "Use preset field"
    }))),
    key: 'custom'
  }
});
const NetworkDirection = () => {
  const {
    getFieldDefaultValue
  } = (0, _shared_imports.useFormContext)();
  const isInternalNetowrksFieldDefined = getFieldDefaultValue('fields.internal_networks_field') !== undefined;
  const [isCustom, setIsCustom] = (0, _react.useState)(isInternalNetowrksFieldDefined);
  const toggleCustom = (0, _react.useCallback)(() => {
    setIsCustom(prev => !prev);
  }, []);
  const internalNetworkFieldProps = (0, _react.useMemo)(() => isCustom ? getInternalNetworkConfig(toggleCustom).internal_networks_field : getInternalNetworkConfig(toggleCustom).internal_networks, [isCustom, toggleCustom]);
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_shared_imports.UseField, {
    config: fieldsConfig.source_ip,
    component: _shared_imports.Field,
    path: "fields.source_ip",
    "data-test-subj": "sourceIpField"
  }), /*#__PURE__*/_react.default.createElement(_shared_imports.UseField, {
    config: fieldsConfig.destination_ip,
    component: _shared_imports.Field,
    path: "fields.destination_ip",
    "data-test-subj": "destinationIpField"
  }), /*#__PURE__*/_react.default.createElement(_target_field.TargetField, {
    helpText: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.ingestPipelines.pipelineEditor.networkDirection.targetFieldHelpText",
      defaultMessage: "Output field. Defaults to {field}.",
      values: {
        field: /*#__PURE__*/_react.default.createElement(_eui.EuiCode, null, 'network.direction')
      }
    })
  }), /*#__PURE__*/_react.default.createElement(_shared_imports.UseField, (0, _extends2.default)({}, internalNetworkFieldProps, {
    component: _shared_imports.Field,
    "data-test-subj": "networkDirectionField"
  })), /*#__PURE__*/_react.default.createElement(_ignore_missing_field.IgnoreMissingField, {
    defaultValue: true,
    serializer: _shared.from.undefinedIfValue(true)
  }));
};
exports.NetworkDirection = NetworkDirection;