"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.MetricsExplorerViewsClient = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _server = require("@kbn/core/server");
var _boom = _interopRequireDefault(require("@hapi/boom"));
var _metrics_explorer_views = require("../../../common/metrics_explorer_views");
var _runtime_types = require("../../../common/runtime_types");
var _metrics_explorer_view = require("../../saved_objects/metrics_explorer_view");
var _types = require("../../saved_objects/metrics_explorer_view/types");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

class MetricsExplorerViewsClient {
  constructor(logger, savedObjectsClient, infraSources) {
    this.logger = logger;
    this.savedObjectsClient = savedObjectsClient;
    this.infraSources = infraSources;
  }
  async find(query) {
    var _query$sourceId;
    this.logger.debug('Trying to load metrics explorer views ...');
    const sourceId = (_query$sourceId = query.sourceId) !== null && _query$sourceId !== void 0 ? _query$sourceId : MetricsExplorerViewsClient.DEFAULT_SOURCE_ID;
    const [sourceConfiguration, metricsExplorerViewSavedObject] = await Promise.all([this.infraSources.getSourceConfiguration(this.savedObjectsClient, sourceId), this.getAllViews()]);
    const defaultView = MetricsExplorerViewsClient.createStaticView(sourceConfiguration.configuration.metricsExplorerDefaultView);
    const views = metricsExplorerViewSavedObject.saved_objects.map(savedObject => this.mapSavedObjectToMetricsExplorerView(savedObject, sourceConfiguration.configuration.metricsExplorerDefaultView));
    const metricsExplorerViews = [defaultView, ...views];
    const sortedMetricsExplorerViews = this.moveDefaultViewOnTop(metricsExplorerViews);
    return sortedMetricsExplorerViews;
  }
  async get(metricsExplorerViewId, query) {
    var _query$sourceId2;
    this.logger.debug(`Trying to load metrics explorer view with id ${metricsExplorerViewId} ...`);
    const sourceId = (_query$sourceId2 = query.sourceId) !== null && _query$sourceId2 !== void 0 ? _query$sourceId2 : MetricsExplorerViewsClient.DEFAULT_SOURCE_ID;

    // Handle the case where the requested resource is the static metrics explorer view
    if (metricsExplorerViewId === MetricsExplorerViewsClient.STATIC_VIEW_ID) {
      const sourceConfiguration = await this.infraSources.getSourceConfiguration(this.savedObjectsClient, sourceId);
      return MetricsExplorerViewsClient.createStaticView(sourceConfiguration.configuration.metricsExplorerDefaultView);
    }
    const [sourceConfiguration, metricsExplorerViewSavedObject] = await Promise.all([this.infraSources.getSourceConfiguration(this.savedObjectsClient, sourceId), this.savedObjectsClient.get(_metrics_explorer_view.metricsExplorerViewSavedObjectName, metricsExplorerViewId)]);
    return this.mapSavedObjectToMetricsExplorerView(metricsExplorerViewSavedObject, sourceConfiguration.configuration.metricsExplorerDefaultView);
  }
  async update(metricsExplorerViewId, attributes, query) {
    var _query$sourceId3;
    this.logger.debug(`Trying to update metrics explorer view with id "${metricsExplorerViewId}"...`);
    const viewId = metricsExplorerViewId !== null && metricsExplorerViewId !== void 0 ? metricsExplorerViewId : _server.SavedObjectsUtils.generateId();

    // Validate there is not a view with the same name
    await this.assertNameConflict(attributes.name, [viewId]);
    const sourceId = (_query$sourceId3 = query.sourceId) !== null && _query$sourceId3 !== void 0 ? _query$sourceId3 : MetricsExplorerViewsClient.DEFAULT_SOURCE_ID;
    const [sourceConfiguration, metricsExplorerViewSavedObject] = await Promise.all([this.infraSources.getSourceConfiguration(this.savedObjectsClient, sourceId), this.savedObjectsClient.create(_metrics_explorer_view.metricsExplorerViewSavedObjectName, attributes, {
      id: viewId,
      overwrite: true
    })]);
    return this.mapSavedObjectToMetricsExplorerView(metricsExplorerViewSavedObject, sourceConfiguration.configuration.metricsExplorerDefaultView);
  }
  delete(metricsExplorerViewId) {
    this.logger.debug(`Trying to delete metrics explorer view with id ${metricsExplorerViewId} ...`);
    return this.savedObjectsClient.delete(_metrics_explorer_view.metricsExplorerViewSavedObjectName, metricsExplorerViewId);
  }
  getAllViews() {
    return this.savedObjectsClient.find({
      type: _metrics_explorer_view.metricsExplorerViewSavedObjectName,
      perPage: 1000 // Fetch 1 page by default with a max of 1000 results
    });
  }

  mapSavedObjectToMetricsExplorerView(savedObject, defaultViewId) {
    const metricsExplorerViewSavedObject = (0, _runtime_types.decodeOrThrow)(_types.metricsExplorerViewSavedObjectRT)(savedObject);
    return {
      id: metricsExplorerViewSavedObject.id,
      version: metricsExplorerViewSavedObject.version,
      updatedAt: metricsExplorerViewSavedObject.updated_at,
      attributes: {
        ...metricsExplorerViewSavedObject.attributes,
        isDefault: metricsExplorerViewSavedObject.id === defaultViewId,
        isStatic: false
      }
    };
  }
  moveDefaultViewOnTop(views) {
    const defaultViewPosition = views.findIndex(view => view.attributes.isDefault);
    if (defaultViewPosition !== -1) {
      const element = views.splice(defaultViewPosition, 1)[0];
      views.unshift(element);
    }
    return views;
  }

  /**
   * We want to control conflicting names on the views
   */
  async assertNameConflict(name, whitelist = []) {
    const results = await this.getAllViews();
    const hasConflict = [MetricsExplorerViewsClient.createStaticView(), ...results.saved_objects].some(obj => !whitelist.includes(obj.id) && obj.attributes.name === name);
    if (hasConflict) {
      throw _boom.default.conflict('A view with that name already exists.');
    }
  }
}
exports.MetricsExplorerViewsClient = MetricsExplorerViewsClient;
(0, _defineProperty2.default)(MetricsExplorerViewsClient, "STATIC_VIEW_ID", '0');
(0, _defineProperty2.default)(MetricsExplorerViewsClient, "DEFAULT_SOURCE_ID", 'default');
(0, _defineProperty2.default)(MetricsExplorerViewsClient, "createStaticView", defaultViewId => ({
  id: _metrics_explorer_views.staticMetricsExplorerViewId,
  attributes: {
    ..._metrics_explorer_views.staticMetricsExplorerViewAttributes,
    isDefault: defaultViewId === MetricsExplorerViewsClient.STATIC_VIEW_ID
  }
}));