"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.mapToApiResponse = exports.getMetricValue = void 0;
var _types = require("../../../lib/metrics/types");
var _types2 = require("./types");
var _constants = require("./constants");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const mapToApiResponse = (params, buckets) => {
  if (!buckets) {
    return {
      type: params.type,
      nodes: []
    };
  }
  const hosts = buckets.map(bucket => {
    const metrics = convertMetricBucket(params, bucket);
    const metadata = convertMetadataBucket(bucket);
    return {
      name: bucket.key,
      metrics,
      metadata
    };
  });
  return {
    type: params.type,
    nodes: hosts
  };
};
exports.mapToApiResponse = mapToApiResponse;
const normalizeValue = value => {
  if (typeof value === 'string') {
    return (value === null || value === void 0 ? void 0 : value.trim().length) === 0 ? null : value;
  }
  return value;
};
const convertMetadataBucket = bucket => {
  const metadataAggregation = bucket[_constants.METADATA_AGGREGATION_NAME];
  return _types.TopMetricsTypeRT.is(metadataAggregation) ? metadataAggregation.top.flatMap(top => Object.entries(top.metrics)).map(([key, value]) => ({
    name: key,
    value: normalizeValue(value)
  })) : [];
};
const convertMetricBucket = (params, bucket) => {
  return params.metrics.map(returnedMetric => {
    var _getMetricValue;
    const metricBucket = bucket[returnedMetric.type];
    return {
      name: returnedMetric.type,
      value: _types2.HostsMetricsSearchValueRT.is(metricBucket) ? (_getMetricValue = getMetricValue(metricBucket)) !== null && _getMetricValue !== void 0 ? _getMetricValue : 0 : null
    };
  });
};
const getMetricValue = valueObject => {
  if (_types2.FilteredMetricsTypeRT.is(valueObject)) {
    return valueObject.result.value;
  }
  if (_types.BasicMetricValueRT.is(valueObject)) {
    return valueObject.value;
  }
  return valueObject;
};
exports.getMetricValue = getMetricValue;