"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.logIndexSavedObjectReferenceRT = exports.logIndexPatternSavedObjectReferenceRT = exports.logIndexNameSavedObjectReferenceRT = exports.TimestampFromString = exports.SourceConfigurationSavedObjectTimestampColumnRT = exports.SourceConfigurationSavedObjectRT = exports.SourceConfigurationSavedObjectMessageColumnRT = exports.SourceConfigurationSavedObjectFieldColumnRT = exports.SourceConfigurationSavedObjectColumnRT = exports.SourceConfigurationSavedObjectAttributesRT = exports.SavedSourceConfigurationSavedObjectRT = void 0;
var rt = _interopRequireWildcard(require("io-ts"));
var _moment = _interopRequireDefault(require("moment"));
var _pipeable = require("fp-ts/lib/pipeable");
var _Either = require("fp-ts/lib/Either");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const TimestampFromString = new rt.Type('TimestampFromString', input => typeof input === 'number', (input, context) => (0, _pipeable.pipe)(rt.string.validate(input, context), (0, _Either.chain)(stringInput => {
  const momentValue = (0, _moment.default)(stringInput);
  return momentValue.isValid() ? rt.success(momentValue.valueOf()) : rt.failure(stringInput, context);
})), output => new Date(output).toISOString());
exports.TimestampFromString = TimestampFromString;
const SourceConfigurationSavedObjectFieldColumnRT = rt.type({
  fieldColumn: rt.type({
    id: rt.string,
    field: rt.string
  })
});
exports.SourceConfigurationSavedObjectFieldColumnRT = SourceConfigurationSavedObjectFieldColumnRT;
const SourceConfigurationSavedObjectMessageColumnRT = rt.type({
  messageColumn: rt.type({
    id: rt.string
  })
});
exports.SourceConfigurationSavedObjectMessageColumnRT = SourceConfigurationSavedObjectMessageColumnRT;
const SourceConfigurationSavedObjectTimestampColumnRT = rt.type({
  timestampColumn: rt.type({
    id: rt.string
  })
});
exports.SourceConfigurationSavedObjectTimestampColumnRT = SourceConfigurationSavedObjectTimestampColumnRT;
const SourceConfigurationSavedObjectColumnRT = rt.union([SourceConfigurationSavedObjectTimestampColumnRT, SourceConfigurationSavedObjectMessageColumnRT, SourceConfigurationSavedObjectFieldColumnRT]);
exports.SourceConfigurationSavedObjectColumnRT = SourceConfigurationSavedObjectColumnRT;
const logIndexPatternSavedObjectReferenceRT = rt.type({
  type: rt.literal('index_pattern'),
  indexPatternId: rt.string
});
exports.logIndexPatternSavedObjectReferenceRT = logIndexPatternSavedObjectReferenceRT;
const logIndexNameSavedObjectReferenceRT = rt.type({
  type: rt.literal('index_name'),
  indexName: rt.string
});
exports.logIndexNameSavedObjectReferenceRT = logIndexNameSavedObjectReferenceRT;
const logIndexSavedObjectReferenceRT = rt.union([logIndexPatternSavedObjectReferenceRT, logIndexNameSavedObjectReferenceRT]);
exports.logIndexSavedObjectReferenceRT = logIndexSavedObjectReferenceRT;
const SourceConfigurationSavedObjectAttributesRT = rt.type({
  name: rt.string,
  description: rt.string,
  metricAlias: rt.string,
  logIndices: logIndexSavedObjectReferenceRT,
  inventoryDefaultView: rt.string,
  metricsExplorerDefaultView: rt.string,
  fields: rt.record(rt.string, rt.unknown),
  logColumns: rt.array(SourceConfigurationSavedObjectColumnRT),
  anomalyThreshold: rt.number
});
exports.SourceConfigurationSavedObjectAttributesRT = SourceConfigurationSavedObjectAttributesRT;
const SavedSourceConfigurationSavedObjectRT = rt.partial(SourceConfigurationSavedObjectAttributesRT.props);
exports.SavedSourceConfigurationSavedObjectRT = SavedSourceConfigurationSavedObjectRT;
const SourceConfigurationSavedObjectRT = rt.intersection([rt.type({
  id: rt.string,
  attributes: SavedSourceConfigurationSavedObjectRT
}), rt.partial({
  version: rt.string,
  updated_at: TimestampFromString
})]);
exports.SourceConfigurationSavedObjectRT = SourceConfigurationSavedObjectRT;