"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.injectReferences = exports.extractReferences = exports.LOG_VIEW_REFERENCE_NAME = void 0;
var _saved_objects = require("../../../saved_objects");
var _log_threshold = require("../../../../common/alerting/logs/log_threshold");
var _log_views = require("../../../../common/log_views");
var _runtime_types = require("../../../../common/runtime_types");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const LOG_VIEW_REFERENCE_NAME = 'log-view-reference-0';
exports.LOG_VIEW_REFERENCE_NAME = LOG_VIEW_REFERENCE_NAME;
const extractReferences = params => {
  if (!_log_views.logViewReferenceRT.is(params.logView)) {
    return {
      params,
      references: []
    };
  }
  const references = [{
    name: LOG_VIEW_REFERENCE_NAME,
    type: _saved_objects.logViewSavedObjectName,
    id: params.logView.logViewId
  }];
  const newParams = {
    ...params,
    logView: {
      ...params.logView,
      logViewId: LOG_VIEW_REFERENCE_NAME
    }
  };
  return {
    params: newParams,
    references
  };
};
exports.extractReferences = extractReferences;
const injectReferences = (params, references) => {
  const decodedParams = (0, _runtime_types.decodeOrThrow)(_log_threshold.ruleParamsRT)(params);
  if (!_log_views.logViewReferenceRT.is(decodedParams.logView)) {
    return decodedParams;
  }
  const matchedReference = references.find(ref => ref.name === LOG_VIEW_REFERENCE_NAME);
  if (!matchedReference) {
    throw new Error(`Could not find reference for ${LOG_VIEW_REFERENCE_NAME}`);
  }
  return {
    ...decodedParams,
    logView: {
      ...decodedParams.logView,
      logViewId: matchedReference.id
    }
  };
};
exports.injectReferences = injectReferences;