"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.isUninitializedLoadingResult = exports.isSuccessLoadingResult = exports.isFailureLoadingResult = exports.isExhaustedLoadingResult = exports.getTimeOrDefault = exports.createSuccessResultReducer = exports.createSuccessResult = exports.createFailureResultReducer = exports.createFailureResult = void 0;
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const isUninitializedLoadingResult = loadingResult => loadingResult.result === 'uninitialized';
exports.isUninitializedLoadingResult = isUninitializedLoadingResult;
const isSuccessLoadingResult = loadingResult => loadingResult.result === 'success';
exports.isSuccessLoadingResult = isSuccessLoadingResult;
const isFailureLoadingResult = loadingResult => loadingResult.result === 'failure';
exports.isFailureLoadingResult = isFailureLoadingResult;
const isExhaustedLoadingResult = loadingResult => isSuccessLoadingResult(loadingResult) && loadingResult.isExhausted;
exports.isExhaustedLoadingResult = isExhaustedLoadingResult;
const getTimeOrDefault = (loadingResult, defaultValue) => isUninitializedLoadingResult(loadingResult) ? defaultValue || null : loadingResult.time;
exports.getTimeOrDefault = getTimeOrDefault;
const createSuccessResult = (parameters, isExhausted) => ({
  isExhausted,
  parameters,
  result: 'success',
  time: Date.now()
});
exports.createSuccessResult = createSuccessResult;
const createSuccessResultReducer = isExhausted => (state, {
  params,
  result
}) => createSuccessResult(params, isExhausted(params, result));
exports.createSuccessResultReducer = createSuccessResultReducer;
const createFailureResult = (parameters, reason) => ({
  parameters,
  reason,
  result: 'failure',
  time: Date.now()
});
exports.createFailureResult = createFailureResult;
const createFailureResultReducer = (convertErrorToString = error => `${error}`) => (state, {
  params,
  error
}) => createFailureResult(params, convertErrorToString(error));
exports.createFailureResultReducer = createFailureResultReducer;