"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.WaffleRegionControls = void 0;
var _eui = require("@elastic/eui");
var _react = _interopRequireWildcard(require("react"));
var _i18n = require("@kbn/i18n");
var _dropdown_button = require("../dropdown_button");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const WaffleRegionControls = props => {
  const {
    region,
    options
  } = props;
  const [isOpen, setIsOpen] = (0, _react.useState)(false);
  const showPopover = (0, _react.useCallback)(() => {
    setIsOpen(true);
  }, [setIsOpen]);
  const closePopover = (0, _react.useCallback)(() => {
    setIsOpen(false);
  }, [setIsOpen]);
  const currentLabel = options.find(o => region === o);
  const changeRegion = (0, _react.useCallback)(val => {
    if (region === val) {
      props.changeRegion('');
    } else {
      props.changeRegion(val);
    }
    closePopover();
  }, [region, closePopover, props]);
  const panels = (0, _react.useMemo)(() => [{
    id: 0,
    title: '',
    items: options.map(o => {
      const icon = o === region ? 'check' : 'empty';
      const panel = {
        name: o,
        onClick: () => changeRegion(o),
        icon
      };
      return panel;
    })
  }], [changeRegion, options, region]);
  const button = /*#__PURE__*/_react.default.createElement(_dropdown_button.DropdownButton, {
    onClick: showPopover,
    label: _i18n.i18n.translate('xpack.infra.waffle.regionLabel', {
      defaultMessage: 'Region'
    })
  }, currentLabel || _i18n.i18n.translate('xpack.infra.waffle.region', {
    defaultMessage: 'All'
  }));
  return /*#__PURE__*/_react.default.createElement(_eui.EuiPopover, {
    isOpen: isOpen,
    id: "regionPanel",
    button: button,
    anchorPosition: "downLeft",
    panelPaddingSize: "none",
    closePopover: closePopover
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiContextMenu, {
    initialPanelId: 0,
    panels: panels
  }));
};
exports.WaffleRegionControls = WaffleRegionControls;