"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.Node = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _polished = require("polished");
var _react = _interopRequireDefault(require("react"));
var _i18n = require("@kbn/i18n");
var _lodash = require("lodash");
var _eui = require("@elastic/eui");
var _common = require("@kbn/kibana-react-plugin/common");
var _conditional_tooltip = require("./conditional_tooltip");
var _color_from_value = require("../../lib/color_from_value");
var _overlay = require("../node_details/overlay");
var _node_context_menu = require("./node_context_menu");
var _alert_flyout = require("../../../../../alerting/inventory/components/alert_flyout");
var _inventory_models = require("../../../../../../common/inventory_models");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const initialState = {
  isPopoverOpen: false,
  isOverlayOpen: false,
  isAlertFlyoutVisible: false,
  isToolTipOpen: false
};
class Node extends _react.default.PureComponent {
  constructor(...args) {
    super(...args);
    (0, _defineProperty2.default)(this, "state", initialState);
    (0, _defineProperty2.default)(this, "openAlertFlyout", () => {
      this.setState({
        isOverlayOpen: false,
        isAlertFlyoutVisible: true
      });
    });
    (0, _defineProperty2.default)(this, "setAlertFlyoutVisible", isOpen => {
      this.setState({
        isAlertFlyoutVisible: isOpen
      });
    });
    (0, _defineProperty2.default)(this, "togglePopover", () => {
      const {
        nodeType
      } = this.props;
      if (nodeType === 'host') {
        this.toggleNewOverlay();
      } else {
        this.setState(prevState => ({
          isPopoverOpen: !prevState.isPopoverOpen
        }));
      }
    });
    (0, _defineProperty2.default)(this, "toggleNewOverlay", () => {
      this.setState(prevState => ({
        isPopoverOpen: !prevState.isOverlayOpen === true ? false : prevState.isPopoverOpen,
        isOverlayOpen: !prevState.isOverlayOpen
      }));
    });
    (0, _defineProperty2.default)(this, "closePopover", () => {
      if (this.state.isPopoverOpen) {
        this.setState({
          isPopoverOpen: false
        });
      }
    });
    (0, _defineProperty2.default)(this, "showToolTip", () => {
      this.setState({
        isToolTipOpen: true
      });
    });
    (0, _defineProperty2.default)(this, "hideToolTip", () => {
      this.setState({
        isToolTipOpen: false
      });
    });
  }
  render() {
    const {
      nodeType,
      node,
      options,
      squareSize,
      bounds,
      formatter,
      currentTime
    } = this.props;
    const {
      isPopoverOpen,
      isAlertFlyoutVisible,
      isToolTipOpen
    } = this.state;
    const metric = (0, _lodash.first)(node.metrics);
    const valueMode = squareSize > 70;
    const ellipsisMode = squareSize > 30;
    const rawValue = metric && metric.value || 0;
    const color = (0, _color_from_value.colorFromValue)(options.legend, rawValue, bounds);
    const value = formatter(rawValue);
    const nodeAriaLabel = _i18n.i18n.translate('xpack.infra.node.ariaLabel', {
      defaultMessage: '{nodeName}, click to open menu',
      values: {
        nodeName: node.name
      }
    });
    const nodeBorder = this.state.isOverlayOpen ? {
      border: 'solid 4px #000'
    } : undefined;
    const bigSquare = /*#__PURE__*/_react.default.createElement(NodeContainer, {
      "data-test-subj": "nodeContainer",
      style: {
        width: squareSize || 0,
        height: squareSize || 0
      },
      onClick: this.togglePopover,
      onMouseOver: this.showToolTip,
      onMouseLeave: this.hideToolTip,
      className: "buttonContainer"
    }, /*#__PURE__*/_react.default.createElement(SquareOuter, {
      color: color,
      style: nodeBorder
    }, /*#__PURE__*/_react.default.createElement(SquareInner, {
      color: color
    }, valueMode ? /*#__PURE__*/_react.default.createElement(ValueInner, {
      "aria-label": nodeAriaLabel
    }, /*#__PURE__*/_react.default.createElement(Label, {
      "data-test-subj": "nodeName",
      color: color
    }, node.name), /*#__PURE__*/_react.default.createElement(Value, {
      "data-test-subj": "nodeValue",
      color: color
    }, value)) : ellipsisMode && /*#__PURE__*/_react.default.createElement(ValueInner, {
      "aria-label": nodeAriaLabel
    }, /*#__PURE__*/_react.default.createElement(Label, {
      color: color
    }, "...")))));
    const smallSquare = /*#__PURE__*/_react.default.createElement(NodeContainerSmall, {
      "data-test-subj": "nodeContainer",
      style: {
        width: squareSize || 0,
        height: squareSize || 0,
        ...nodeBorder
      },
      onClick: this.togglePopover,
      onMouseOver: this.showToolTip,
      onMouseLeave: this.hideToolTip,
      color: color
    });
    const nodeSquare = valueMode || ellipsisMode ? bigSquare : smallSquare;
    return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, isPopoverOpen ? /*#__PURE__*/_react.default.createElement(_eui.EuiPopover, {
      button: nodeSquare,
      isOpen: isPopoverOpen,
      closePopover: this.closePopover,
      anchorPosition: "downCenter",
      style: {
        height: squareSize
      }
    }, /*#__PURE__*/_react.default.createElement(_node_context_menu.NodeContextMenu, {
      node: node,
      nodeType: nodeType,
      options: options,
      currentTime: currentTime
    })) : isToolTipOpen ? /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
      delay: "regular",
      position: "right",
      content: /*#__PURE__*/_react.default.createElement(_conditional_tooltip.ConditionalToolTip, {
        currentTime: currentTime,
        node: node,
        nodeType: nodeType
      })
    }, nodeSquare) : nodeSquare, this.state.isOverlayOpen && /*#__PURE__*/_react.default.createElement(_overlay.NodeContextPopover, {
      openAlertFlyout: this.openAlertFlyout,
      node: node,
      nodeType: nodeType,
      isOpen: this.state.isOverlayOpen,
      options: options,
      currentTime: currentTime,
      onClose: this.toggleNewOverlay
    }), isAlertFlyoutVisible && /*#__PURE__*/_react.default.createElement(_alert_flyout.AlertFlyout, {
      filter: `${(0, _inventory_models.findInventoryFields)(nodeType).id}: "${node.id}"`,
      options: options,
      nodeType: nodeType,
      setVisible: this.setAlertFlyoutVisible,
      visible: isAlertFlyoutVisible
    }));
  }
}
exports.Node = Node;
const NodeContainer = _common.euiStyled.div`
  position: relative;
  cursor: pointer;
`;
const NodeContainerSmall = _common.euiStyled.div`
  cursor: pointer;
  position: relative;
  background-color: ${props => (0, _polished.darken)(0.1, props.color)};
  border-radius: 3px;
  margin: 2px;
  box-shadow: 0 1px 2px 0 rgba(0, 0, 0, 0.2);
`;
const SquareOuter = _common.euiStyled.div`
  position: absolute;
  top: 4px;
  left: 4px;
  bottom: 4px;
  right: 4px;
  background-color: ${props => (0, _polished.darken)(0.1, props.color)};
  border-radius: 3px;
  box-shadow: 0 1px 2px 0 rgba(0, 0, 0, 0.2);
`;
const SquareInner = _common.euiStyled.div`
  position: absolute;
  top: 0;
  right: 0;
  bottom: 2px;
  left: 0;
  border-radius: 3px;
  background-color: ${props => props.color};
`;
const ValueInner = _common.euiStyled.button`
  position: absolute;
  top: 0;
  left: 0;
  right: 0;
  bottom: 0;
  display: flex;
  line-height: 1.2em;
  align-items: center;
  align-content: center;
  padding: 1em;
  overflow: hidden;
  flex-wrap: wrap;
  width: 100%;
  border: none;
  &:focus {
    outline: none !important;
    border: ${params => {
  var _params$theme;
  return (_params$theme = params.theme) === null || _params$theme === void 0 ? void 0 : _params$theme.eui.euiFocusRingSize;
}} solid
      ${params => {
  var _params$theme2;
  return (_params$theme2 = params.theme) === null || _params$theme2 === void 0 ? void 0 : _params$theme2.eui.euiFocusRingColor;
}};
    box-shadow: none;
  }
`;
const SquareTextContent = _common.euiStyled.div`
  text-align: center;
  width: 100%;
  overflow: hidden;
  text-overflow: ellipsis;
  white-space: nowrap;
  flex: 1 0 auto;
  color: ${props => (0, _polished.readableColor)(props.color)};
`;
const Value = (0, _common.euiStyled)(SquareTextContent)`
  font-weight: bold;
  font-size: 0.9em;
  line-height: 1.2em;
`;
const Label = (0, _common.euiStyled)(SquareTextContent)`
  font-size: 0.7em;
  margin-bottom: 0.7em;
`;