"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.MetricsContextMenu = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _get_custom_metric_label = require("../../../../../../../common/formatters/get_custom_metric_label");
var _snapshot_api = require("../../../../../../../common/http_api/snapshot_api");
var _types = require("../../../../../../../common/inventory_models/types");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const MetricsContextMenu = ({
  onClose,
  onChange,
  metric,
  options,
  customMetrics
}) => {
  const id = _snapshot_api.SnapshotCustomMetricInputRT.is(metric) && metric.id ? metric.id : metric.type;
  const handleClick = (0, _react.useCallback)(val => {
    if (!_types.SnapshotMetricTypeRT.is(val)) {
      const selectedMetric = customMetrics.find(m => m.id === val);
      if (selectedMetric) {
        onChange(selectedMetric);
      }
    } else {
      onChange({
        type: val
      });
    }
    onClose();
  }, [customMetrics, onChange, onClose]);
  const panels = [{
    id: 0,
    title: '',
    items: [...options.map(o => {
      const icon = o.value === id ? 'check' : 'empty';
      const panel = {
        name: o.text,
        onClick: () => handleClick(o.value),
        icon
      };
      return panel;
    }), ...customMetrics.map(m => {
      const icon = m.id === id ? 'check' : 'empty';
      const panel = {
        name: (0, _get_custom_metric_label.getCustomMetricLabel)(m),
        onClick: () => handleClick(m.id),
        icon
      };
      return panel;
    })]
  }];
  return /*#__PURE__*/_react.default.createElement(_eui.EuiContextMenu, {
    initialPanelId: 0,
    panels: panels
  });
};
exports.MetricsContextMenu = MetricsContextMenu;