"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ProcessRow = exports.CopilotProcessRow = void 0;
var _react = _interopRequireWildcard(require("react"));
var _i18n = require("@kbn/i18n");
var _eui = require("@elastic/eui");
var _common = require("@kbn/kibana-react-plugin/common");
var _public = require("@kbn/observability-plugin/public");
var _common2 = require("@kbn/observability-plugin/common");
var _useToggle = _interopRequireDefault(require("react-use/lib/useToggle"));
var _process_row_charts = require("./process_row_charts");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const CopilotProcessRow = ({
  command
}) => {
  const coPilotService = (0, _public.useCoPilot)();
  const explainProcessParams = (0, _react.useMemo)(() => {
    return command ? {
      command
    } : undefined;
  }, [command]);
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, coPilotService !== null && coPilotService !== void 0 && coPilotService.isEnabled() && explainProcessParams ? /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_public.CoPilotPrompt, {
    coPilot: coPilotService,
    title: explainProcessMessageTitle,
    params: explainProcessParams,
    promptId: _common2.CoPilotPromptId.InfraExplainProcess,
    feedbackEnabled: true
  })))) : null);
};
exports.CopilotProcessRow = CopilotProcessRow;
const ProcessRow = ({
  cells,
  item,
  supportCopilot = false
}) => {
  const [isExpanded, toggle] = (0, _useToggle.default)(false);
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiTableRow, null, /*#__PURE__*/_react.default.createElement(_eui.EuiTableRowCell, {
    isExpander: true,
    textOnly: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    "data-test-subj": "infraProcessRowButton",
    iconType: isExpanded ? 'arrowDown' : 'arrowRight',
    "aria-expanded": isExpanded,
    onClick: toggle
  })), cells), /*#__PURE__*/_react.default.createElement(_eui.EuiTableRow, {
    isExpandable: true,
    isExpandedRow: isExpanded
  }, isExpanded && /*#__PURE__*/_react.default.createElement(ExpandedRowCell, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s"
  }), /*#__PURE__*/_react.default.createElement(ExpandedRowDescriptionList, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "s"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement("div", null, /*#__PURE__*/_react.default.createElement(_eui.EuiDescriptionListTitle, null, _i18n.i18n.translate('xpack.infra.metrics.nodeDetails.processes.expandedRowLabelCommand', {
    defaultMessage: 'Command'
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiDescriptionListDescription, null, /*#__PURE__*/_react.default.createElement(ExpandedCommandLine, null, item.command)))), item.apmTrace && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    "data-test-subj": "infraProcessRowViewTraceInApmButton"
  }, _i18n.i18n.translate('xpack.infra.metrics.nodeDetails.processes.viewTraceInAPM', {
    defaultMessage: 'View trace in APM'
  })))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGrid, {
    columns: 2,
    gutterSize: "s",
    responsive: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiDescriptionListTitle, null, _i18n.i18n.translate('xpack.infra.metrics.nodeDetails.processes.expandedRowLabelPID', {
    defaultMessage: 'PID'
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiDescriptionListDescription, null, /*#__PURE__*/_react.default.createElement(CodeListItem, null, item.pid))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiDescriptionListTitle, null, _i18n.i18n.translate('xpack.infra.metrics.nodeDetails.processes.expandedRowLabelUser', {
    defaultMessage: 'User'
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiDescriptionListDescription, null, /*#__PURE__*/_react.default.createElement(CodeListItem, null, item.user))), /*#__PURE__*/_react.default.createElement(_process_row_charts.ProcessRowCharts, {
    command: item.command
  })), supportCopilot && /*#__PURE__*/_react.default.createElement(CopilotProcessRow, {
    command: item.command
  })))));
};
exports.ProcessRow = ProcessRow;
const explainProcessMessageTitle = _i18n.i18n.translate('xpack.infra.hostFlyout.explainProcessMessageTitle', {
  defaultMessage: "What's this process?"
});
const ExpandedRowDescriptionList = (0, _common.euiStyled)(_eui.EuiDescriptionList).attrs({
  compressed: true
})`
  width: 100%;
`;
const CodeListItem = (0, _common.euiStyled)(_eui.EuiCode).attrs({
  transparentBackground: true
})`
  padding: 0 !important;
  & code.euiCodeBlock__code {
    white-space: nowrap !important;
    vertical-align: middle;
  }
`;
const ExpandedCommandLine = (0, _common.euiStyled)(_eui.EuiCode).attrs({
  transparentBackground: true
})`
  padding: 0 !important;
  margin-bottom: ${props => props.theme.eui.euiSizeS};
`;
const ExpandedRowCell = (0, _common.euiStyled)(_eui.EuiTableRowCell).attrs({
  textOnly: false,
  colSpan: 6
})`
  padding-top: ${props => props.theme.eui.euiSizeM} !important;
  padding-bottom: ${props => props.theme.eui.euiSizeM} !important;
  background-color: ${props => props.theme.eui.euiColorLightestShade};
`;