"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.OsqueryTab = void 0;
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _react = _interopRequireWildcard(require("react"));
var _use_kibana = require("../../../../../../../hooks/use_kibana");
var _shared = require("../shared");
var _metrics_source = require("../../../../../../../containers/metrics_source");
var _inventory_models = require("../../../../../../../../common/inventory_models");
var _use_metadata = require("../../../../../../../components/asset_details/hooks/use_metadata");
var _use_waffle_time = require("../../../../hooks/use_waffle_time");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const TabComponent = props => {
  const nodeId = props.node.id;
  const nodeType = props.nodeType;
  const inventoryModel = (0, _inventory_models.findInventoryModel)(nodeType);
  const {
    sourceId
  } = (0, _metrics_source.useSourceContext)();
  const {
    currentTimeRange
  } = (0, _use_waffle_time.useWaffleTimeContext)();
  const {
    loading,
    metadata
  } = (0, _use_metadata.useMetadata)(nodeId, nodeType, inventoryModel.requiredMetrics, sourceId, currentTimeRange);
  const {
    services: {
      osquery
    }
  } = (0, _use_kibana.useKibanaContextForPlugin)();

  // @ts-expect-error
  const OsqueryAction = osquery === null || osquery === void 0 ? void 0 : osquery.OsqueryAction;

  // avoids component rerender when resizing the popover
  const content = (0, _react.useMemo)(() => {
    var _metadata$info, _metadata$info$agent;
    // TODO: Add info when Osquery plugin is not available
    if (loading || !OsqueryAction) {
      return /*#__PURE__*/_react.default.createElement(_shared.TabContent, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSkeletonText, {
        lines: 10
      }));
    }
    return /*#__PURE__*/_react.default.createElement(_shared.TabContent, null, /*#__PURE__*/_react.default.createElement(OsqueryAction, {
      agentId: metadata === null || metadata === void 0 ? void 0 : (_metadata$info = metadata.info) === null || _metadata$info === void 0 ? void 0 : (_metadata$info$agent = _metadata$info.agent) === null || _metadata$info$agent === void 0 ? void 0 : _metadata$info$agent.id,
      hideAgentsField: true,
      formType: "simple"
    }));
  }, [OsqueryAction, loading, metadata]);
  return content;
};
const OsqueryTab = {
  id: 'osquery',
  name: _i18n.i18n.translate('xpack.infra.nodeDetails.tabs.osquery', {
    defaultMessage: 'Osquery'
  }),
  content: TabComponent
};
exports.OsqueryTab = OsqueryTab;