"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ChartSection = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _charts = require("@elastic/charts");
var _moment = _interopRequireDefault(require("moment"));
var _react = _interopRequireDefault(require("react"));
var _use_is_dark_mode = require("../../../../../../../hooks/use_is_dark_mode");
var _get_chart_theme = require("../../../../../../../utils/get_chart_theme");
var _series_chart = require("../../../../../metrics_explorer/components/series_chart");
var _chart_header = require("./chart_header");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const CHART_SIZE = ['100%', 160];
const ChartSection = ({
  title,
  style,
  chartRef,
  series,
  tickFormatterForTime,
  tickFormatter,
  onPointerUpdate,
  domain,
  stack = false
}) => {
  const isDarkMode = (0, _use_is_dark_mode.useIsDarkMode)();
  const metrics = series.map(chartSeries => chartSeries.metric);
  const tooltipProps = {
    headerFormatter: ({
      value
    }) => (0, _moment.default)(value).format('Y-MM-DD HH:mm:ss.SSS')
  };
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_chart_header.ChartHeader, {
    title: title,
    metrics: metrics
  }), /*#__PURE__*/_react.default.createElement(_charts.Chart, {
    ref: chartRef,
    size: CHART_SIZE
  }, series.map((chartSeries, index) => /*#__PURE__*/_react.default.createElement(_series_chart.MetricExplorerSeriesChart, {
    type: style,
    metric: chartSeries.metric,
    id: "0",
    key: chartSeries.series.id,
    series: chartSeries.series,
    stack: stack
  })), /*#__PURE__*/_react.default.createElement(_charts.Axis, {
    id: 'timestamp',
    position: _charts.Position.Bottom,
    showOverlappingTicks: true,
    tickFormat: tickFormatterForTime
  }), /*#__PURE__*/_react.default.createElement(_charts.Axis, {
    id: 'values',
    position: _charts.Position.Left,
    tickFormat: tickFormatter,
    domain: domain,
    ticks: 6,
    gridLine: {
      visible: true
    }
  }), /*#__PURE__*/_react.default.createElement(_charts.Tooltip, tooltipProps), /*#__PURE__*/_react.default.createElement(_charts.Settings, (0, _extends2.default)({
    onPointerUpdate: onPointerUpdate
  }, (0, _get_chart_theme.getTimelineChartThemes)(isDarkMode)))));
};
exports.ChartSection = ChartSection;