"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.NodeContextPopover = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _react = _interopRequireWildcard(require("react"));
var _common = require("@kbn/kibana-react-plugin/common");
var _public = require("@kbn/kibana-react-plugin/public");
var _public2 = require("@kbn/observability-shared-plugin/public");
var _metrics = require("./tabs/metrics/metrics");
var _logs = require("./tabs/logs");
var _processes = require("./tabs/processes");
var _properties = require("./tabs/properties");
var _anomalies = require("./tabs/anomalies/anomalies");
var _osquery = require("./tabs/osquery");
var _shared = require("./tabs/shared");
var _link_to = require("../../../../link_to");
var _inventory_models = require("../../../../../../common/inventory_models");
var _navigate_to_uptime = require("../../lib/navigate_to_uptime");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const NodeContextPopover = ({
  isOpen,
  node,
  nodeType,
  currentTime,
  options,
  onClose,
  openAlertFlyout
}) => {
  // eslint-disable-next-line react-hooks/exhaustive-deps
  const tabConfigs = [_metrics.MetricsTab, _logs.LogsTab, _processes.ProcessesTab, _properties.PropertiesTab, _anomalies.AnomaliesTab, _osquery.OsqueryTab];
  const inventoryModel = (0, _inventory_models.findInventoryModel)(nodeType);
  const nodeDetailFrom = currentTime - inventoryModel.metrics.defaultTimeRangeInSeconds * 1000;
  const {
    application,
    share
  } = (0, _public.useKibana)().services;
  const uiCapabilities = application === null || application === void 0 ? void 0 : application.capabilities;
  const canCreateAlerts = (0, _react.useMemo)(() => {
    var _uiCapabilities$infra;
    return Boolean(uiCapabilities === null || uiCapabilities === void 0 ? void 0 : (_uiCapabilities$infra = uiCapabilities.infrastructure) === null || _uiCapabilities$infra === void 0 ? void 0 : _uiCapabilities$infra.save);
  }, [uiCapabilities]);
  const tabs = (0, _react.useMemo)(() => {
    return tabConfigs.map(m => {
      const TabContent = m.content;
      return {
        ...m,
        content: /*#__PURE__*/_react.default.createElement(TabContent, {
          onClose: onClose,
          node: node,
          nodeType: nodeType,
          currentTime: currentTime,
          options: options
        })
      };
    });
  }, [tabConfigs, node, nodeType, currentTime, onClose, options]);
  const [selectedTab, setSelectedTab] = (0, _react.useState)(0);
  const nodeDetailMenuItemLinkProps = (0, _public2.useLinkProps)({
    ...(0, _link_to.getNodeDetailUrl)({
      nodeType,
      nodeId: node.id,
      from: nodeDetailFrom,
      to: currentTime
    })
  });
  const apmField = nodeType === 'host' ? 'host.hostname' : inventoryModel.fields.id;
  const apmTracesMenuItemLinkProps = (0, _public2.useLinkProps)({
    app: 'apm',
    hash: 'traces',
    search: {
      kuery: `${apmField}:"${node.id}"`
    }
  });
  if (!isOpen) {
    return null;
  }
  return /*#__PURE__*/_react.default.createElement(_eui.EuiPortal, null, /*#__PURE__*/_react.default.createElement(_eui.EuiOutsideClickDetector, {
    onOutsideClick: onClose
  }, /*#__PURE__*/_react.default.createElement(OverlayPanel, null, /*#__PURE__*/_react.default.createElement(OverlayHeader, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    responsive: false,
    gutterSize: "m"
  }, /*#__PURE__*/_react.default.createElement(OverlayTitle, {
    grow: true
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "xs"
  }, /*#__PURE__*/_react.default.createElement("h4", null, node.name))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "m",
    responsive: false
  }, canCreateAlerts && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    "data-test-subj": "infraNodeContextPopoverCreateInventoryRuleButton",
    onClick: openAlertFlyout,
    size: "xs",
    iconSide: 'left',
    flush: "both",
    iconType: "bell"
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.infra.infra.nodeDetails.createAlertLink",
    defaultMessage: "Create inventory rule"
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, (0, _extends2.default)({
    "data-test-subj": "infraNodeContextPopoverOpenAsPageButton",
    size: "xs",
    iconSide: 'left',
    iconType: 'popout',
    flush: "both"
  }, nodeDetailMenuItemLinkProps), /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.infra.infra.nodeDetails.openAsPage",
    defaultMessage: "Open as page"
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, {
    size: "s",
    onClick: onClose,
    iconType: "cross"
  }))))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiTabs, {
    size: "s"
  }, tabs.map((tab, i) => /*#__PURE__*/_react.default.createElement(_eui.EuiTab, {
    key: tab.id,
    isSelected: i === selectedTab,
    onClick: () => setSelectedTab(i)
  }, tab.name)), /*#__PURE__*/_react.default.createElement(_eui.EuiTab, apmTracesMenuItemLinkProps, /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
    type: "popout"
  }), ' ', /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.infra.infra.nodeDetails.apmTabLabel",
    defaultMessage: "APM"
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiTab, {
    onClick: () => (0, _navigate_to_uptime.navigateToUptime)(share.url.locators, nodeType, node)
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
    type: "popout"
  }), ' ', /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.infra.infra.nodeDetails.updtimeTabLabel",
    defaultMessage: "Uptime"
  })))), tabs[selectedTab].content)));
};
exports.NodeContextPopover = NodeContextPopover;
const OverlayHeader = _common.euiStyled.div`
  padding-top: ${props => props.theme.eui.euiSizeM};
  padding-right: ${props => props.theme.eui.euiSizeM};
  padding-left: ${props => props.theme.eui.euiSizeM};
  background-color: ${props => props.theme.eui.euiPageBackgroundColor};
  box-shadow: inset 0 -1px ${props => props.theme.eui.euiBorderColor};
`;
const OverlayPanel = (0, _common.euiStyled)(_eui.EuiPanel).attrs({
  paddingSize: 'none'
})`
  display: flex;
  flex-direction: column;
  position: absolute;
  right: 16px;
  top: ${_shared.OVERLAY_Y_START}px;
  width: 100%;
  max-width: 720px;
  z-index: 2;
  max-height: calc(100vh - ${_shared.OVERLAY_Y_START + _shared.OVERLAY_BOTTOM_MARGIN}px);
  overflow: hidden;

  @media (max-width: 752px) {
    border-radius: 0px !important;
    left: 0px;
    right: 0px;
    top: 97px;
    bottom: 0;
    max-height: calc(100vh - 97px);
    max-width: 100%;
  }
`;
const OverlayTitle = (0, _common.euiStyled)(_eui.EuiFlexItem)`
  overflow: hidden;
  & h4 {
    text-overflow: ellipsis;
    overflow: hidden;
    white-space: nowrap;
  }
`;