"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.NoAnomaliesFound = exports.AnomaliesTable = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _i18n = require("@kbn/i18n");
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _common = require("@kbn/kibana-react-plugin/common");
var _public = require("@kbn/observability-shared-plugin/public");
var _datemath = require("../../../../../../../utils/datemath");
var _use_sorting = require("../../../../../../../hooks/use_sorting");
var _use_metrics_k8s_anomalies = require("../../../../hooks/use_metrics_k8s_anomalies");
var _use_metrics_hosts_anomalies = require("../../../../hooks/use_metrics_hosts_anomalies");
var _pagination = require("./pagination");
var _annomaly_summary = require("./annomaly_summary");
var _anomaly_severity_indicator = require("../../../../../../../components/logging/log_analysis_results/anomaly_severity_indicator");
var _metrics_source = require("../../../../../../../containers/metrics_source");
var _flyout_home = require("../flyout_home");
var _use_waffle_view_state = require("../../../../hooks/use_waffle_view_state");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const AnomalyActionMenu = ({
  jobId,
  type,
  startTime,
  closeFlyout,
  influencerField,
  influencers,
  disableShowInInventory
}) => {
  const [isOpen, setIsOpen] = (0, _react.useState)(false);
  const close = (0, _react.useCallback)(() => setIsOpen(false), [setIsOpen]);
  const handleToggleMenu = (0, _react.useCallback)(() => setIsOpen(!isOpen), [isOpen]);
  const {
    onViewChange
  } = (0, _use_waffle_view_state.useWaffleViewState)();
  const showInInventory = (0, _react.useCallback)(() => {
    const metricTypeMap = {
      memory_usage: 'memory',
      network_in: 'rx',
      network_out: 'tx'
    };
    // parse the anomaly job id for metric type
    const jobIdParts = jobId.split('-');
    const jobIdMetric = jobIdParts[jobIdParts.length - 1];
    const metricType = metricTypeMap[jobIdMetric.replace(/hosts_|k8s_/, '')];
    const anomalyViewParams = {
      metric: {
        type: metricType
      },
      sort: {
        by: 'name',
        direction: 'desc'
      },
      groupBy: [],
      nodeType: type === 'metrics_k8s' ? 'pod' : 'host',
      view: 'map',
      customOptions: [],
      customMetrics: [],
      boundsOverride: {
        max: 1,
        min: 0
      },
      autoBounds: true,
      accountId: '',
      region: '',
      autoReload: false,
      filterQuery: {
        expression: influencers.reduce((query, i) => {
          if (query) {
            query = `${query} or `;
          }
          return `${query} ${influencerField}: "${i}"`;
        }, ''),
        kind: 'kuery'
      },
      legend: {
        palette: 'cool',
        reverseColors: false,
        steps: 10
      },
      time: startTime
    };
    onViewChange({
      attributes: anomalyViewParams
    });
    closeFlyout();
  }, [jobId, onViewChange, startTime, type, influencers, influencerField, closeFlyout]);
  const anomaliesUrl = (0, _public.useLinkProps)({
    app: 'ml',
    pathname: `/explorer?_g=${(0, _flyout_home.createResultsUrl)([jobId.toString()])}`
  });
  const items = [/*#__PURE__*/_react.default.createElement(_eui.EuiContextMenuItem, (0, _extends2.default)({
    key: "openInAnomalyExplorer",
    icon: "popout"
  }, anomaliesUrl), /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.infra.ml.anomalyFlyout.actions.openInAnomalyExplorer",
    defaultMessage: "Open in Anomaly Explorer"
  }))];
  if (!disableShowInInventory) {
    items.push( /*#__PURE__*/_react.default.createElement(_eui.EuiContextMenuItem, {
      key: "showInInventory",
      icon: "search",
      onClick: showInInventory
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.infra.ml.anomalyFlyout.actions.showInInventory",
      defaultMessage: "Show in Inventory"
    })));
  }
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiPopover, {
    anchorPosition: "downRight",
    panelPaddingSize: "none",
    button: /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, {
      iconType: "boxesHorizontal",
      onClick: handleToggleMenu,
      "aria-label": _i18n.i18n.translate('xpack.infra.ml.anomalyFlyout.actions.openActionMenu', {
        defaultMessage: 'Open'
      })
    }),
    isOpen: isOpen,
    closePopover: close
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiContextMenuPanel, {
    items: items
  })));
};
const NoAnomaliesFound = (0, _common.withTheme)(({
  theme
}) => /*#__PURE__*/_react.default.createElement(_eui.EuiText, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
  size: "xl"
}), /*#__PURE__*/_react.default.createElement("p", null, /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
  type: "eyeClosed",
  size: "xl",
  color: theme.eui.euiColorMediumShade
})), /*#__PURE__*/_react.default.createElement("h3", {
  "data-test-subj": "noAnomaliesFoundMsg"
}, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
  id: "xpack.infra.ml.anomalyFlyout.anomalyTable.noAnomaliesFound",
  defaultMessage: "No anomalies found"
})), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
  size: "m"
}), /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
  color: "subdued"
}, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
  id: "xpack.infra.ml.anomalyFlyout.anomalyTable.noAnomaliesSuggestion",
  defaultMessage: "Try modifying your search or selected time range."
}))));
exports.NoAnomaliesFound = NoAnomaliesFound;
const AnomaliesTable = props => {
  const {
    closeFlyout,
    hostName
  } = props;
  const [search, setSearch] = (0, _react.useState)('');
  const [start, setStart] = (0, _react.useState)('now-30d');
  const [end, setEnd] = (0, _react.useState)('now');
  const trackMetric = (0, _public.useUiTracker)({
    app: 'infra_metrics'
  });
  const [timeRange, setTimeRange] = (0, _react.useState)({
    start: (0, _datemath.datemathToEpochMillis)(start) || 0,
    end: (0, _datemath.datemathToEpochMillis)(end, 'up') || 0
  });
  const {
    sorting,
    setSorting
  } = (0, _use_sorting.useSorting)({
    field: 'startTime',
    direction: 'desc'
  });
  const jobOptions = [{
    id: `hosts`,
    label: _i18n.i18n.translate('xpack.infra.ml.anomalyFlyout.hostBtn', {
      defaultMessage: 'Hosts'
    }),
    'data-test-subj': 'anomaliesHostComboBoxItem'
  }, {
    id: `k8s`,
    label: _i18n.i18n.translate('xpack.infra.ml.anomalyFlyout.podsBtn', {
      defaultMessage: 'Kubernetes Pods'
    }),
    'data-test-subj': 'anomaliesK8sComboBoxItem'
  }];
  const [jobType, setJobType] = (0, _react.useState)('hosts');
  const [selectedJobType, setSelectedJobType] = (0, _react.useState)([jobOptions.find(item => item.id === 'hosts') || jobOptions[0]]);
  const {
    source
  } = (0, _metrics_source.useSourceContext)();
  const anomalyThreshold = source === null || source === void 0 ? void 0 : source.configuration.anomalyThreshold;
  const onTimeChange = (0, _react.useCallback)(({
    isInvalid,
    start: startChange,
    end: endChange
  }) => {
    if (!isInvalid) {
      setStart(startChange);
      setEnd(endChange);
      setTimeRange({
        start: (0, _datemath.datemathToEpochMillis)(startChange),
        end: (0, _datemath.datemathToEpochMillis)(endChange, 'up')
      });
    }
  }, []);
  const anomalyParams = (0, _react.useMemo)(() => ({
    sourceId: 'default',
    anomalyThreshold: anomalyThreshold || 0,
    startTime: timeRange.start,
    endTime: timeRange.end,
    defaultSortOptions: {
      direction: (sorting === null || sorting === void 0 ? void 0 : sorting.direction) || 'desc',
      field: (sorting === null || sorting === void 0 ? void 0 : sorting.field) || 'startTime'
    },
    defaultPaginationOptions: {
      pageSize: 10
    }
  }), [timeRange.start, timeRange.end, sorting === null || sorting === void 0 ? void 0 : sorting.field, sorting === null || sorting === void 0 ? void 0 : sorting.direction, anomalyThreshold]);
  const {
    metricsHostsAnomalies,
    getMetricsHostsAnomalies,
    page: hostPage,
    changeSortOptions: hostChangeSort,
    fetchNextPage: hostFetchNextPage,
    fetchPreviousPage: hostFetchPrevPage,
    isLoadingMetricsHostsAnomalies: hostLoading
  } = (0, _use_metrics_hosts_anomalies.useMetricsHostsAnomaliesResults)(anomalyParams);
  const {
    metricsK8sAnomalies,
    getMetricsK8sAnomalies,
    page: k8sPage,
    changeSortOptions: k8sChangeSort,
    fetchNextPage: k8sFetchNextPage,
    fetchPreviousPage: k8sPreviousPage,
    isLoadingMetricsK8sAnomalies: k8sLoading
  } = (0, _use_metrics_k8s_anomalies.useMetricsK8sAnomaliesResults)(anomalyParams);
  const page = (0, _react.useMemo)(() => jobType === 'hosts' ? hostPage : k8sPage, [jobType, hostPage, k8sPage]);
  const isLoading = (0, _react.useMemo)(() => jobType === 'hosts' ? hostLoading : k8sLoading, [jobType, hostLoading, k8sLoading]);
  const fetchNextPage = (0, _react.useMemo)(() => jobType === 'hosts' ? hostFetchNextPage : k8sFetchNextPage, [jobType, hostFetchNextPage, k8sFetchNextPage]);
  const fetchPreviousPage = (0, _react.useMemo)(() => jobType === 'hosts' ? hostFetchPrevPage : k8sPreviousPage, [jobType, hostFetchPrevPage, k8sPreviousPage]);
  const getAnomalies = (0, _react.useMemo)(() => {
    if (jobType === 'hosts') {
      return getMetricsHostsAnomalies;
    } else if (jobType === 'k8s') {
      return getMetricsK8sAnomalies;
    }
  }, [jobType, getMetricsK8sAnomalies, getMetricsHostsAnomalies]);
  const results = (0, _react.useMemo)(() => {
    if (jobType === 'hosts') {
      return metricsHostsAnomalies;
    } else {
      return metricsK8sAnomalies;
    }
  }, [jobType, metricsHostsAnomalies, metricsK8sAnomalies]);
  const onSearchChange = (0, _react.useCallback)(e => {
    setSearch(e.target.value);
  }, []);
  const changeJobType = (0, _react.useCallback)(selectedOptions => {
    setSelectedJobType(selectedOptions);
    setJobType(selectedOptions[0].id);
  }, []);
  const changeSortOptions = (0, _react.useCallback)(nextSortOptions => {
    if (jobType === 'hosts') {
      hostChangeSort(nextSortOptions);
    } else {
      k8sChangeSort(nextSortOptions);
    }
  }, [hostChangeSort, k8sChangeSort, jobType]);
  (0, _react.useEffect)(() => {
    if (results) {
      results.forEach(r => {
        if (r.influencers.length > 100) {
          trackMetric({
            metric: 'metrics_ml_anomaly_detection_more_than_100_influencers'
          });
        }
      });
    }
  }, [results, trackMetric]);
  const onTableChange = criteria => {
    var _criteria$sort, _criteria$sort2;
    setSorting(criteria.sort);
    changeSortOptions({
      field: (criteria === null || criteria === void 0 ? void 0 : (_criteria$sort = criteria.sort) === null || _criteria$sort === void 0 ? void 0 : _criteria$sort.field) || 'startTime',
      direction: (criteria === null || criteria === void 0 ? void 0 : (_criteria$sort2 = criteria.sort) === null || _criteria$sort2 === void 0 ? void 0 : _criteria$sort2.direction) || 'desc'
    });
  };
  let columns = [{
    field: 'startTime',
    name: _i18n.i18n.translate('xpack.infra.ml.anomalyFlyout.columnTime', {
      defaultMessage: 'Time'
    }),
    width: '15%',
    sortable: true,
    textOnly: true,
    truncateText: true,
    render: startTime => /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedDate, {
      value: startTime,
      year: "numeric",
      month: "short",
      day: "2-digit"
    })
  }, {
    field: 'jobId',
    name: _i18n.i18n.translate('xpack.infra.ml.anomalyFlyout.columnJob', {
      defaultMessage: 'Job'
    }),
    width: '25%',
    render: jobId => jobId,
    'data-test-subj': 'anomalyRow'
  }, {
    field: 'anomalyScore',
    name: _i18n.i18n.translate('xpack.infra.ml.anomalyFlyout.columnSeverit', {
      defaultMessage: 'Severity'
    }),
    width: '15%',
    sortable: true,
    render: anomalyScore => /*#__PURE__*/_react.default.createElement(_anomaly_severity_indicator.AnomalySeverityIndicator, {
      anomalyScore: anomalyScore
    })
  }, {
    field: 'typical',
    name: _i18n.i18n.translate('xpack.infra.ml.anomalyFlyout.columnSummary', {
      defaultMessage: 'Summary'
    }),
    width: '15%',
    textOnly: true,
    render: (typical, item) => /*#__PURE__*/_react.default.createElement(_annomaly_summary.AnomalySummary, {
      anomaly: item
    })
  }, {
    field: 'influencers',
    name: _i18n.i18n.translate('xpack.infra.ml.anomalyFlyout.columnInfluencerName', {
      defaultMessage: 'Node name'
    }),
    width: '20%',
    textOnly: true,
    truncateText: true,
    render: influencers => influencers.join(',')
  }, {
    name: _i18n.i18n.translate('xpack.infra.ml.anomalyFlyout.columnActionsName', {
      defaultMessage: 'Actions'
    }),
    width: '10%',
    actions: [{
      render: anomaly => {
        return /*#__PURE__*/_react.default.createElement(AnomalyActionMenu, {
          jobId: anomaly.jobId,
          type: anomaly.type,
          influencerField: anomaly.type === 'metrics_hosts' ? 'host.name' : 'kubernetes.pod.uid',
          disableShowInInventory: anomaly.influencers.length > 100,
          influencers: anomaly.influencers,
          startTime: anomaly.startTime,
          closeFlyout: closeFlyout
        });
      }
    }]
  }];
  columns = hostName ? columns.filter(c => {
    if ('field' in c) {
      return c.field !== 'influencers';
    }
    return true;
  }) : columns;
  (0, _react.useEffect)(() => {
    if (getAnomalies) {
      getAnomalies(undefined, search, hostName);
    }
  }, [getAnomalies, search, hostName]);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: 1
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiSuperDatePicker, {
    start: start,
    end: end,
    showUpdateButton: false,
    onTimeChange: onTimeChange,
    width: "full"
  })), !hostName && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    alignItems: "center"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: 3
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFieldSearch, {
    "data-test-subj": "infraAnomaliesTableFieldSearch",
    fullWidth: true,
    placeholder: _i18n.i18n.translate('xpack.infra.ml.anomalyFlyout.searchPlaceholder', {
      defaultMessage: 'Search'
    }),
    value: search,
    onChange: onSearchChange,
    isClearable: true
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: 1
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiComboBox, {
    placeholder: _i18n.i18n.translate('xpack.infra.ml.anomalyFlyout.jobTypeSelect', {
      defaultMessage: 'Select group'
    }),
    singleSelection: {
      asPlainText: true
    },
    options: jobOptions,
    selectedOptions: selectedJobType,
    onChange: changeJobType,
    isClearable: false,
    "data-test-subj": "anomaliesComboBoxType"
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: 'm'
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiBasicTable, {
    columns: columns,
    items: results,
    sorting: {
      sort: sorting
    },
    onChange: onTableChange,
    hasActions: true,
    loading: isLoading,
    noItemsMessage: isLoading ? /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.infra.ml.anomalyFlyout.anomalyTable.loading",
      defaultMessage: "Loading anomalies"
    }) : /*#__PURE__*/_react.default.createElement(NoAnomaliesFound, null)
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "l"
  }), /*#__PURE__*/_react.default.createElement(_pagination.PaginationControls, {
    fetchNextPage: fetchNextPage,
    fetchPreviousPage: fetchPreviousPage,
    page: page,
    isLoading: isLoading
  }));
};
exports.AnomaliesTable = AnomaliesTable;