"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.AnomalySummary = void 0;
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _react = _interopRequireDefault(require("react"));
var _log_analysis = require("../../../../../../../../common/log_analysis");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const AnomalySummary = ({
  anomaly
}) => {
  const {
    actual,
    typical
  } = anomaly;
  const moreThanExpectedAnomalyMessage = _i18n.i18n.translate('xpack.infra.ml.anomalyFlyout.anomaliesTableMoreThanExpectedAnomalyMessage', {
    defaultMessage: 'more'
  });
  const fewerThanExpectedAnomalyMessage = _i18n.i18n.translate('xpack.infra.ml.anomalyFlyout.anomaliesTableFewerThanExpectedAnomalyMessage', {
    defaultMessage: 'fewer'
  });
  const isMore = actual > typical;
  const message = isMore ? moreThanExpectedAnomalyMessage : fewerThanExpectedAnomalyMessage;
  const ratio = isMore ? actual / typical : typical / actual;
  const icon = isMore ? 'sortUp' : 'sortDown';
  // Edge case scenarios where actual and typical might sit at 0.
  const useRatio = ratio !== Infinity;
  const ratioMessage = useRatio ? `${(0, _log_analysis.formatOneDecimalPlace)(ratio)}x` : '';
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "s",
    responsive: false,
    alignItems: "center"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    component: "span"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
    type: icon
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    component: "span"
  }, `${ratioMessage} ${message}`));
};
exports.AnomalySummary = AnomalySummary;