"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useHostFlyoutUrlState = exports.DEFAULT_STATE = void 0;
var rt = _interopRequireWildcard(require("io-ts"));
var _pipeable = require("fp-ts/lib/pipeable");
var _Either = require("fp-ts/lib/Either");
var _function = require("fp-ts/lib/function");
var _isEmpty = _interopRequireDefault(require("lodash/isEmpty"));
var _omitBy = _interopRequireDefault(require("lodash/omitBy"));
var _types = require("../../../../components/asset_details/types");
var _use_url_state = require("../../../../utils/use_url_state");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const DEFAULT_STATE = {
  itemId: '',
  tabId: _types.FlyoutTabIds.METADATA,
  processSearch: undefined,
  metadataSearch: undefined
};
exports.DEFAULT_STATE = DEFAULT_STATE;
const HOST_FLYOUT_URL_STATE_KEY = 'flyout';
const useHostFlyoutUrlState = () => {
  const [urlState, setUrlState] = (0, _use_url_state.useUrlState)({
    defaultState: null,
    decodeUrlState,
    encodeUrlState,
    urlStateKey: HOST_FLYOUT_URL_STATE_KEY
  });
  const setHostFlyoutState = newProps => {
    if (!newProps) {
      setUrlState(DEFAULT_STATE);
    } else {
      const payload = (0, _omitBy.default)(newProps, _isEmpty.default);
      setUrlState({
        ...(urlState !== null && urlState !== void 0 ? urlState : DEFAULT_STATE),
        ...payload
      });
    }
  };
  return [urlState, setHostFlyoutState];
};
exports.useHostFlyoutUrlState = useHostFlyoutUrlState;
const FlyoutTabIdRT = rt.union([rt.literal(_types.FlyoutTabIds.METADATA), rt.literal(_types.FlyoutTabIds.PROCESSES), rt.literal(_types.FlyoutTabIds.LOGS)]);
const HostFlyoutStateRT = rt.intersection([rt.type({
  itemId: rt.string,
  tabId: FlyoutTabIdRT
}), rt.partial({
  processSearch: rt.string,
  metadataSearch: rt.string,
  logsSearch: rt.string
})]);
const HostFlyoutUrlRT = rt.union([HostFlyoutStateRT, rt.null]);
const encodeUrlState = HostFlyoutUrlRT.encode;
const decodeUrlState = value => {
  return (0, _pipeable.pipe)(HostFlyoutUrlRT.decode(value), (0, _Either.fold)((0, _function.constant)(undefined), _function.identity));
};