"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.MetricsGrid = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _metric_chart = require("./metric_chart");
var _host_metrics_docs_link = require("../../metric_explanation/host_metrics_docs_link");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const DEFAULT_BREAKDOWN_SIZE = 20;
const CHARTS_IN_ORDER = [{
  title: _i18n.i18n.translate('xpack.infra.hostsViewPage.tabs.metricsCharts.cpuUsage', {
    defaultMessage: 'CPU Usage'
  }),
  type: 'cpuUsage'
}, {
  title: _i18n.i18n.translate('xpack.infra.hostsViewPage.tabs.metricsCharts.normalizedLoad1m', {
    defaultMessage: 'Normalized Load'
  }),
  type: 'normalizedLoad1m'
}, {
  title: _i18n.i18n.translate('xpack.infra.hostsViewPage.tabs.metricsCharts.memoryUsage', {
    defaultMessage: 'Memory Usage'
  }),
  type: 'memoryUsage'
}, {
  title: _i18n.i18n.translate('xpack.infra.hostsViewPage.tabs.metricsCharts.memoryFree', {
    defaultMessage: 'Memory Free'
  }),
  type: 'memoryFree'
}, {
  title: _i18n.i18n.translate('xpack.infra.hostsViewPage.tabs.metricsCharts.diskSpaceUsed', {
    defaultMessage: 'Disk Space Usage'
  }),
  type: 'diskSpaceUsage'
}, {
  title: _i18n.i18n.translate('xpack.infra.hostsViewPage.tabs.metricsCharts.diskSpaceAvailable', {
    defaultMessage: 'Disk Space Available'
  }),
  type: 'diskSpaceAvailable'
}, {
  title: _i18n.i18n.translate('xpack.infra.hostsViewPage.tabs.metricsCharts.diskIORead', {
    defaultMessage: 'Disk Read IOPS'
  }),
  type: 'diskIORead'
}, {
  title: _i18n.i18n.translate('xpack.infra.hostsViewPage.tabs.metricsCharts.diskIOWrite', {
    defaultMessage: 'Disk Write IOPS'
  }),
  type: 'diskIOWrite'
}, {
  title: _i18n.i18n.translate('xpack.infra.hostsViewPage.tabs.metricsCharts.diskReadThroughput', {
    defaultMessage: 'Disk Read Throughput'
  }),
  type: 'diskReadThroughput'
}, {
  title: _i18n.i18n.translate('xpack.infra.hostsViewPage.tabs.metricsCharts.diskWriteThroughput', {
    defaultMessage: 'Disk Write Throughput'
  }),
  type: 'diskWriteThroughput'
}, {
  title: _i18n.i18n.translate('xpack.infra.hostsViewPage.tabs.metricsCharts.rx', {
    defaultMessage: 'Network Inbound (RX)'
  }),
  type: 'rx'
}, {
  title: _i18n.i18n.translate('xpack.infra.hostsViewPage.tabs.metricsCharts.tx', {
    defaultMessage: 'Network Outbound (TX)'
  }),
  type: 'tx'
}];
const MetricsGrid = /*#__PURE__*/_react.default.memo(() => {
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_host_metrics_docs_link.HostMetricsDocsLink, null), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGrid, {
    columns: 2,
    gutterSize: "s",
    "data-test-subj": "hostsView-metricChart"
  }, CHARTS_IN_ORDER.map(({
    fullRow,
    ...chartProp
  }) => /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    key: chartProp.type,
    style: fullRow ? {
      gridColumn: '1/-1'
    } : {}
  }, /*#__PURE__*/_react.default.createElement(_metric_chart.MetricChart, (0, _extends2.default)({
    breakdownSize: DEFAULT_BREAKDOWN_SIZE
  }, chartProp))))));
});
exports.MetricsGrid = MetricsGrid;