"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.AlertsTabContent = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _public = require("@kbn/observability-plugin/public");
var _ruleDataUtils = require("@kbn/rule-data-utils");
var _use_kibana = require("../../../../../../hooks/use_kibana");
var _height_retainer = require("../../../../../../components/height_retainer");
var _use_unified_search = require("../../../hooks/use_unified_search");
var _config = require("../config");
var _use_alerts_query = require("../../../hooks/use_alerts_query");
var _alerts_status_filter = _interopRequireDefault(require("./alerts_status_filter"));
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const AlertsTabContent = () => {
  const {
    services
  } = (0, _use_kibana.useKibanaContextForPlugin)();
  const {
    alertStatus,
    setAlertStatus,
    alertsEsQueryByStatus
  } = (0, _use_alerts_query.useAlertsQuery)();
  const {
    onSubmit,
    searchCriteria
  } = (0, _use_unified_search.useUnifiedSearchContext)();
  const {
    triggersActionsUi
  } = services;
  const {
    alertsTableConfigurationRegistry,
    getAlertsStateTable: AlertsStateTable
  } = triggersActionsUi;
  return /*#__PURE__*/_react.default.createElement(_height_retainer.HeightRetainer, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column",
    gutterSize: "m",
    "data-test-subj": "hostsView-alerts"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    justifyContent: "flexStart",
    alignItems: "center"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_alerts_status_filter.default, {
    onChange: setAlertStatus,
    status: alertStatus
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(MemoAlertSummaryWidget, {
    alertsQuery: alertsEsQueryByStatus,
    dateRange: searchCriteria.dateRange,
    onRangeSelection: onSubmit
  })), alertsEsQueryByStatus && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(AlertsStateTable, {
    alertsTableConfigurationRegistry: alertsTableConfigurationRegistry,
    configurationId: _ruleDataUtils.AlertConsumers.OBSERVABILITY,
    featureIds: _config.infraAlertFeatureIds,
    flyoutSize: "s",
    id: _config.ALERTS_TABLE_ID,
    pageSize: _config.ALERTS_PER_PAGE,
    query: alertsEsQueryByStatus,
    showAlertStatusWithFlapping: true,
    showExpandToDetails: false
  }))));
};
exports.AlertsTabContent = AlertsTabContent;
const MemoAlertSummaryWidget = /*#__PURE__*/_react.default.memo(({
  alertsQuery,
  dateRange,
  onRangeSelection
}) => {
  const {
    services
  } = (0, _use_kibana.useKibanaContextForPlugin)();
  const summaryTimeRange = useSummaryTimeRange(dateRange);
  const {
    charts,
    triggersActionsUi
  } = services;
  const {
    getAlertSummaryWidget: AlertSummaryWidget
  } = triggersActionsUi;
  const onBrushEnd = brushEvent => {
    const {
      x
    } = brushEvent;
    if (x) {
      const [start, end] = x;
      const from = new Date(start).toISOString();
      const to = new Date(end).toISOString();
      onRangeSelection({
        dateRange: {
          from,
          to
        }
      });
    }
  };
  const chartProps = {
    theme: charts.theme.useChartsTheme(),
    baseTheme: charts.theme.useChartsBaseTheme(),
    onBrushEnd
  };
  return /*#__PURE__*/_react.default.createElement(AlertSummaryWidget, {
    chartProps: chartProps,
    featureIds: _config.infraAlertFeatureIds,
    filter: alertsQuery,
    fullSize: true,
    timeRange: summaryTimeRange
  });
});
const useSummaryTimeRange = unifiedSearchDateRange => {
  const timeBuckets = (0, _public.useTimeBuckets)();
  const bucketSize = (0, _react.useMemo)(() => (0, _public.calculateTimeRangeBucketSize)(unifiedSearchDateRange, timeBuckets), [unifiedSearchDateRange, timeBuckets]);
  return (0, _public.getAlertSummaryTimeRange)(unifiedSearchDateRange, (bucketSize === null || bucketSize === void 0 ? void 0 : bucketSize.intervalString) || _config.DEFAULT_INTERVAL, (bucketSize === null || bucketSize === void 0 ? void 0 : bucketSize.dateFormat) || _config.DEFAULT_DATE_FORMAT);
};