"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.StreamPageLogsContentForState = exports.StreamPageLogsContent = void 0;
var _eui = require("@elastic/eui");
var _common = require("@kbn/kibana-react-plugin/common");
var _react = _interopRequireWildcard(require("react"));
var _usePrevious = _interopRequireDefault(require("react-use/lib/usePrevious"));
var _auto_sizer = require("../../../components/auto_sizer");
var _log_entry_flyout = require("../../../components/logging/log_entry_flyout");
var _log_minimap = require("../../../components/logging/log_minimap");
var _log_text_stream = require("../../../components/logging/log_text_stream");
var _page = require("../../../components/page");
var _log_flyout = require("../../../containers/logs/log_flyout");
var _log_highlights = require("../../../containers/logs/log_highlights");
var _log_position = require("../../../containers/logs/log_position");
var _log_stream = require("../../../containers/logs/log_stream");
var _log_summary = require("../../../containers/logs/log_summary");
var _log_view_configuration = require("../../../containers/logs/log_view_configuration");
var _view_log_in_context = require("../../../containers/logs/view_log_in_context");
var _with_log_textview = require("../../../containers/logs/with_log_textview");
var _use_kibana = require("../../../hooks/use_kibana");
var _use_log_view = require("../../../hooks/use_log_view");
var _datemath = require("../../../utils/datemath");
var _page_toolbar = require("./page_toolbar");
var _page_view_log_in_context = require("./page_view_log_in_context");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const PAGE_THRESHOLD = 2;
const StreamPageLogsContent = /*#__PURE__*/_react.default.memo(({
  filterQuery,
  logStreamPageCallbacks
}) => {
  const {
    data: {
      query: {
        queryString
      }
    }
  } = (0, _use_kibana.useKibanaContextForPlugin)().services;
  const {
    resolvedLogView,
    logView,
    logViewReference
  } = (0, _use_log_view.useLogViewContext)();
  const {
    textScale,
    textWrap
  } = (0, _log_view_configuration.useLogViewConfigurationContext)();
  const {
    surroundingLogsId,
    setSurroundingLogsId,
    closeFlyout: closeLogEntryFlyout,
    openFlyout: openLogEntryFlyout,
    isFlyoutOpen,
    logEntryId: flyoutLogEntryId
  } = (0, _log_flyout.useLogEntryFlyoutContext)();
  const {
    startTimestamp,
    endTimestamp,
    isStreaming,
    targetPosition,
    visibleMidpointTime,
    visibleTimeInterval,
    reportVisiblePositions,
    jumpToTargetPosition,
    startLiveStreaming,
    stopLiveStreaming,
    startDateExpression,
    endDateExpression,
    updateDateRange,
    lastCompleteDateRangeExpressionUpdate
  } = (0, _log_position.useLogPositionStateContext)();
  const {
    isReloading,
    entries,
    topCursor,
    bottomCursor,
    hasMoreAfter: hasMoreAfterEnd,
    hasMoreBefore: hasMoreBeforeStart,
    isLoadingMore,
    lastLoadedTime,
    fetchEntries,
    fetchPreviousEntries,
    fetchNextEntries,
    fetchNewestEntries
  } = (0, _log_stream.useLogStreamContext)();
  const prevStartTimestamp = (0, _usePrevious.default)(startTimestamp);
  const prevEndTimestamp = (0, _usePrevious.default)(endTimestamp);
  const prevFilterQuery = (0, _usePrevious.default)(filterQuery);
  const prevLastCompleteDateRangeExpressionUpdate = (0, _usePrevious.default)(lastCompleteDateRangeExpressionUpdate);

  // Refetch entries if...
  (0, _react.useEffect)(() => {
    const isFirstLoad = !prevStartTimestamp || !prevEndTimestamp;
    const completeDateRangeExpressionHasChanged = lastCompleteDateRangeExpressionUpdate !== prevLastCompleteDateRangeExpressionUpdate;
    const isCenterPointOutsideLoadedRange = targetPosition != null && (topCursor != null && targetPosition.time < topCursor.time || bottomCursor != null && targetPosition.time > bottomCursor.time);
    const hasQueryChanged = filterQuery !== prevFilterQuery;
    if (isFirstLoad || completeDateRangeExpressionHasChanged || isCenterPointOutsideLoadedRange || hasQueryChanged) {
      if (isStreaming) {
        fetchNewestEntries();
      } else {
        fetchEntries();
      }
    }
  }, [fetchEntries, fetchNewestEntries, isStreaming, prevStartTimestamp, prevEndTimestamp, startTimestamp, endTimestamp, targetPosition, topCursor, bottomCursor, filterQuery, prevFilterQuery, lastCompleteDateRangeExpressionUpdate, prevLastCompleteDateRangeExpressionUpdate]);
  const {
    logSummaryHighlights,
    currentHighlightKey,
    logEntryHighlightsById
  } = (0, _log_highlights.useLogHighlightsStateContext)();
  const items = (0, _react.useMemo)(() => isReloading ? [] : entries.map(logEntry => createLogEntryStreamItem(logEntry, logEntryHighlightsById[logEntry.id] || [])), [entries, isReloading, logEntryHighlightsById]);
  const [, {
    setContextEntry
  }] = (0, _view_log_in_context.useViewLogInProviderContext)();
  const handleDateRangeExtension = (0, _react.useCallback)(newDateRange => {
    updateDateRange(newDateRange);
    if ('startDateExpression' in newDateRange && (0, _datemath.isValidDatemath)(newDateRange.startDateExpression)) {
      fetchPreviousEntries({
        force: true,
        extendTo: (0, _datemath.datemathToEpochMillis)(newDateRange.startDateExpression)
      });
    }
    if ('endDateExpression' in newDateRange && (0, _datemath.isValidDatemath)(newDateRange.endDateExpression)) {
      fetchNextEntries({
        force: true,
        extendTo: (0, _datemath.datemathToEpochMillis)(newDateRange.endDateExpression)
      });
    }
  }, [updateDateRange, fetchPreviousEntries, fetchNextEntries]);
  const handlePagination = (0, _react.useCallback)(params => {
    reportVisiblePositions(params);
    if (!params.fromScroll) {
      return;
    }
    if (isLoadingMore) {
      return;
    }
    if (params.pagesBeforeStart < PAGE_THRESHOLD) {
      fetchPreviousEntries();
    } else if (params.pagesAfterEnd < PAGE_THRESHOLD) {
      fetchNextEntries();
    }
  }, [reportVisiblePositions, isLoadingMore, fetchPreviousEntries, fetchNextEntries]);
  const setFilter = (0, _react.useCallback)((filter, flyoutItemId, timeKey) => {
    queryString.setQuery(filter);
    if (timeKey) {
      jumpToTargetPosition(timeKey);
    }
    setSurroundingLogsId(flyoutItemId);
    stopLiveStreaming();
  }, [jumpToTargetPosition, queryString, setSurroundingLogsId, stopLiveStreaming]);
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_with_log_textview.WithLogTextviewUrlState, null), /*#__PURE__*/_react.default.createElement(_log_flyout.WithFlyoutOptionsUrlState, null), /*#__PURE__*/_react.default.createElement(_page_toolbar.LogsToolbar, null), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m"
  }), /*#__PURE__*/_react.default.createElement(_page_view_log_in_context.PageViewLogInContext, null), isFlyoutOpen ? /*#__PURE__*/_react.default.createElement(_log_entry_flyout.LogEntryFlyout, {
    logEntryId: flyoutLogEntryId,
    onCloseFlyout: closeLogEntryFlyout,
    onSetFieldFilter: setFilter,
    logViewReference: logViewReference
  }) : null, /*#__PURE__*/_react.default.createElement(_page.PageContent, {
    key: `${logViewReference.type === 'log-view-reference' ? logViewReference.logViewId : logViewReference.id}-${logView === null || logView === void 0 ? void 0 : logView.version}`
  }, /*#__PURE__*/_react.default.createElement(_log_text_stream.ScrollableLogTextStreamView, {
    columnConfigurations: resolvedLogView && resolvedLogView.columns || [],
    hasMoreAfterEnd: hasMoreAfterEnd,
    hasMoreBeforeStart: hasMoreBeforeStart,
    isLoadingMore: isLoadingMore,
    isReloading: isReloading,
    isStreaming: isStreaming,
    items: items,
    jumpToTarget: jumpToTargetPosition,
    lastLoadedTime: lastLoadedTime,
    reloadItems: fetchEntries,
    reportVisibleInterval: handlePagination,
    scale: textScale,
    target: targetPosition,
    wrap: textWrap,
    onOpenLogEntryFlyout: openLogEntryFlyout,
    setContextEntry: setContextEntry,
    highlightedItem: surroundingLogsId ? surroundingLogsId : null,
    currentHighlightKey: currentHighlightKey,
    startDateExpression: startDateExpression,
    endDateExpression: endDateExpression,
    updateDateRange: handleDateRangeExtension,
    startLiveStreaming: startLiveStreaming
  }), /*#__PURE__*/_react.default.createElement(_auto_sizer.AutoSizer, {
    content: true,
    bounds: true,
    detectAnyWindowResize: "height"
  }, ({
    measureRef,
    bounds: {
      height = 0
    },
    content: {
      width = 0
    }
  }) => {
    return /*#__PURE__*/_react.default.createElement(LogPageMinimapColumn, {
      ref: measureRef
    }, /*#__PURE__*/_react.default.createElement(_log_summary.WithSummary, null, ({
      buckets,
      start,
      end
    }) => /*#__PURE__*/_react.default.createElement(_log_minimap.LogMinimap, {
      start: start,
      end: end,
      height: height,
      width: width,
      highlightedInterval: isReloading ? null : visibleTimeInterval,
      jumpToTarget: jumpToTargetPosition,
      summaryBuckets: buckets,
      summaryHighlightBuckets: logSummaryHighlights.length > 0 ? logSummaryHighlights[0].buckets : [],
      target: visibleMidpointTime
    })));
  })));
});
exports.StreamPageLogsContent = StreamPageLogsContent;
const StreamPageLogsContentForState = /*#__PURE__*/_react.default.memo(({
  logStreamPageState,
  logStreamPageCallbacks
}) => {
  const {
    context: {
      parsedQuery
    }
  } = logStreamPageState;
  return /*#__PURE__*/_react.default.createElement(StreamPageLogsContent, {
    filterQuery: parsedQuery,
    logStreamPageCallbacks: logStreamPageCallbacks
  });
});
exports.StreamPageLogsContentForState = StreamPageLogsContentForState;
const LogPageMinimapColumn = _common.euiStyled.div`
  flex: 1 0 0%;
  overflow: hidden;
  min-width: 100px;
  max-width: 100px;
  display: flex;
  flex-direction: column;
`;
const createLogEntryStreamItem = (logEntry, highlights) => ({
  kind: 'logEntry',
  logEntry,
  highlights
});