"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.IndexPatternSelector = void 0;
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _react = _interopRequireWildcard(require("react"));
var _use_kibana_index_patterns = require("../../../hooks/use_kibana_index_patterns");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const IndexPatternSelector = ({
  indexPatternId,
  isLoading,
  isReadOnly,
  onChangeIndexPatternId
}) => {
  const {
    indexPatternTitles: availableIndexPatterns,
    latestIndexPatternTitlesRequest,
    fetchIndexPatternTitles
  } = (0, _use_kibana_index_patterns.useKibanaIndexPatternTitles)();
  (0, _react.useEffect)(() => {
    fetchIndexPatternTitles();
  }, [fetchIndexPatternTitles]);
  const availableOptions = (0, _react.useMemo)(() => {
    const options = [...availableIndexPatterns.map(({
      id,
      title
    }) => ({
      key: id,
      label: title,
      value: id
    })), ...(indexPatternId == null || availableIndexPatterns.some(({
      id
    }) => id === indexPatternId) ? [] : [{
      key: indexPatternId,
      label: _i18n.i18n.translate('xpack.infra.logSourceConfiguration.missingDataViewsLabel', {
        defaultMessage: `Missing data view {indexPatternId}`,
        values: {
          indexPatternId
        }
      }),
      value: indexPatternId
    }])];
    return options;
  }, [availableIndexPatterns, indexPatternId]);
  const selectedOptions = (0, _react.useMemo)(() => availableOptions.filter(({
    key
  }) => key === indexPatternId), [availableOptions, indexPatternId]);
  const changeSelectedIndexPatterns = (0, _react.useCallback)(([newlySelectedOption]) => {
    if (typeof (newlySelectedOption === null || newlySelectedOption === void 0 ? void 0 : newlySelectedOption.key) === 'string') {
      return onChangeIndexPatternId(newlySelectedOption.key);
    }
    return onChangeIndexPatternId(undefined);
  }, [onChangeIndexPatternId]);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiComboBox, {
    isLoading: isLoading || latestIndexPatternTitlesRequest.state === 'pending',
    isDisabled: isReadOnly,
    options: availableOptions,
    placeholder: indexPatternSelectorPlaceholder,
    selectedOptions: selectedOptions,
    singleSelection: {
      asPlainText: true
    },
    onChange: changeSelectedIndexPatterns
  });
};
exports.IndexPatternSelector = IndexPatternSelector;
const indexPatternSelectorPlaceholder = _i18n.i18n.translate('xpack.infra.logSourceConfiguration.dataViewSelectorPlaceholder', {
  defaultMessage: 'Choose a data view'
});