"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.exampleTimestampFormat = exports.exampleMessageScale = exports.exampleMessageColumnConfigurations = exports.columnWidths = exports.LogEntryExampleMessageHeaders = exports.LogEntryExampleMessage = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _react = _interopRequireWildcard(require("react"));
var _moment = _interopRequireDefault(require("moment"));
var _rison = require("@kbn/rison");
var _i18n = require("@kbn/i18n");
var _public = require("@kbn/ml-plugin/public");
var _common = require("@kbn/kibana-react-plugin/common");
var _public2 = require("@kbn/observability-shared-plugin/public");
var _use_kibana = require("../../../../../hooks/use_kibana");
var _log_analysis = require("../../../../../../common/log_analysis");
var _log_text_stream = require("../../../../../components/logging/log_text_stream");
var _column_headers = require("../../../../../components/logging/log_text_stream/column_headers");
var _job_parameters = require("../../../../../../common/log_analysis/job_parameters");
var _source_configuration = require("../../../../../utils/source_configuration");
var _datetime = require("../../../../../../common/formatters/datetime");
var _log_flyout = require("../../../../../containers/logs/log_flyout");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const exampleMessageScale = 'medium';
exports.exampleMessageScale = exampleMessageScale;
const exampleTimestampFormat = 'time';
exports.exampleTimestampFormat = exampleTimestampFormat;
const MENU_LABEL = _i18n.i18n.translate('xpack.infra.logAnomalies.logEntryExamplesMenuLabel', {
  defaultMessage: 'View actions for log entry'
});
const VIEW_DETAILS_LABEL = _i18n.i18n.translate('xpack.infra.logs.analysis.logEntryExamplesViewDetailsLabel', {
  defaultMessage: 'View details'
});
const VIEW_IN_STREAM_LABEL = _i18n.i18n.translate('xpack.infra.logs.analysis.logEntryExamplesViewInStreamLabel', {
  defaultMessage: 'View in stream'
});
const VIEW_ANOMALY_IN_ML_LABEL = _i18n.i18n.translate('xpack.infra.logs.analysis.logEntryExamplesViewAnomalyInMlLabel', {
  defaultMessage: 'View anomaly in machine learning'
});
const LogEntryExampleMessage = ({
  id,
  dataset,
  message,
  timestamp,
  tiebreaker,
  timeRange,
  anomaly
}) => {
  const {
    services: {
      ml,
      http,
      application
    }
  } = (0, _use_kibana.useKibanaContextForPlugin)();
  const [isHovered, setIsHovered] = (0, _react.useState)(false);
  const [isMenuOpen, setIsMenuOpen] = (0, _react.useState)(false);
  const openMenu = (0, _react.useCallback)(() => setIsMenuOpen(true), []);
  const closeMenu = (0, _react.useCallback)(() => setIsMenuOpen(false), []);
  const setItemIsHovered = (0, _react.useCallback)(() => setIsHovered(true), []);
  const setItemIsNotHovered = (0, _react.useCallback)(() => setIsHovered(false), []);
  const {
    openFlyout: openLogEntryFlyout
  } = (0, _log_flyout.useLogEntryFlyoutContext)();

  // handle special cases for the dataset value
  const humanFriendlyDataset = (0, _log_analysis.getFriendlyNameForPartitionId)(dataset);
  const viewInStreamLinkProps = (0, _public2.useLinkProps)({
    app: 'logs',
    pathname: 'stream',
    search: {
      logPosition: (0, _rison.encode)({
        end: (0, _moment.default)(timeRange.endTime).format('YYYY-MM-DDTHH:mm:ss.SSSZ'),
        position: {
          tiebreaker,
          time: timestamp
        },
        start: (0, _moment.default)(timeRange.startTime).format('YYYY-MM-DDTHH:mm:ss.SSSZ'),
        streamLive: false
      }),
      flyoutOptions: (0, _rison.encode)({
        surroundingLogsId: id
      }),
      ...(dataset ? {
        logFilter: (0, _rison.encode)({
          expression: `${_job_parameters.partitionField}: ${dataset}`,
          kind: 'kuery'
        })
      } : {})
    }
  });
  const viewAnomalyInMachineLearningLink = (0, _public.useMlHref)(ml, http.basePath.get(), {
    page: _public.ML_PAGES.SINGLE_METRIC_VIEWER,
    pageState: {
      jobIds: [anomaly.jobId],
      timeRange: {
        from: (0, _moment.default)(timeRange.startTime).format('YYYY-MM-DDTHH:mm:ss.SSSZ'),
        to: (0, _moment.default)(timeRange.endTime).format('YYYY-MM-DDTHH:mm:ss.SSSZ'),
        mode: 'absolute'
      },
      entities: {
        [_job_parameters.partitionField]: dataset,
        ...((0, _log_analysis.isCategoryAnomaly)(anomaly) ? {
          mlcategory: anomaly.categoryId
        } : {})
      }
    }
  });
  const handleMlLinkClick = (0, _react.useCallback)(e => {
    if (!viewAnomalyInMachineLearningLink || !(0, _public2.shouldHandleLinkEvent)(e)) return;
    application.navigateToUrl(viewAnomalyInMachineLearningLink);
  }, [viewAnomalyInMachineLearningLink, application]);
  const menuItems = (0, _react.useMemo)(() => {
    if (!viewInStreamLinkProps.onClick || !viewAnomalyInMachineLearningLink) {
      return undefined;
    }
    return [{
      label: VIEW_DETAILS_LABEL,
      onClick: () => {
        openLogEntryFlyout(id);
      }
    }, {
      label: VIEW_IN_STREAM_LABEL,
      onClick: viewInStreamLinkProps.onClick,
      href: viewInStreamLinkProps.href
    }, {
      label: VIEW_ANOMALY_IN_ML_LABEL,
      onClick: handleMlLinkClick,
      href: viewAnomalyInMachineLearningLink
    }];
  }, [id, openLogEntryFlyout, viewInStreamLinkProps, viewAnomalyInMachineLearningLink, handleMlLinkClick]);
  return /*#__PURE__*/_react.default.createElement(_log_text_stream.LogEntryRowWrapper, {
    scale: exampleMessageScale,
    onMouseEnter: setItemIsHovered,
    onMouseLeave: setItemIsNotHovered
  }, /*#__PURE__*/_react.default.createElement(_log_text_stream.LogEntryColumn, columnWidths[timestampColumnId], /*#__PURE__*/_react.default.createElement(_log_text_stream.LogEntryTimestampColumn, {
    format: exampleTimestampFormat,
    time: timestamp
  })), /*#__PURE__*/_react.default.createElement(_log_text_stream.LogEntryColumn, columnWidths[messageColumnId], /*#__PURE__*/_react.default.createElement(_log_text_stream.LogEntryMessageColumn, {
    columnValue: {
      columnId: messageColumnId,
      message: [{
        field: 'message',
        value: [message],
        highlights: []
      }]
    },
    highlights: noHighlights,
    isActiveHighlight: false,
    wrapMode: "none"
  })), /*#__PURE__*/_react.default.createElement(_log_text_stream.LogEntryColumn, columnWidths[datasetColumnId], /*#__PURE__*/_react.default.createElement(_log_text_stream.LogEntryFieldColumn, {
    columnValue: {
      columnId: datasetColumnId,
      field: 'event.dataset',
      value: [humanFriendlyDataset],
      highlights: []
    },
    highlights: noHighlights,
    isActiveHighlight: false,
    wrapMode: "none"
  })), /*#__PURE__*/_react.default.createElement(_log_text_stream.LogEntryColumn, (0, _extends2.default)({
    key: "logColumn iconLogColumn iconLogColumn:details"
  }, columnWidths[_log_text_stream.iconColumnId]), (isHovered || isMenuOpen) && menuItems ? /*#__PURE__*/_react.default.createElement(_log_text_stream.LogEntryContextMenu, {
    "aria-label": MENU_LABEL,
    isOpen: isMenuOpen,
    onOpen: openMenu,
    onClose: closeMenu,
    items: menuItems
  }) : null));
};
exports.LogEntryExampleMessage = LogEntryExampleMessage;
const noHighlights = [];
const timestampColumnId = 'log-entry-example-timestamp-column';
const messageColumnId = 'log-entry-examples-message-column';
const datasetColumnId = 'log-entry-examples-dataset-column';
const DETAIL_FLYOUT_ICON_MIN_WIDTH = 32;
const COLUMN_PADDING = 8;
const columnWidths = {
  [timestampColumnId]: {
    growWeight: 0,
    shrinkWeight: 0,
    // w_score - w_padding = 130 px  - 8 px
    baseWidth: '122px'
  },
  [messageColumnId]: {
    growWeight: 1,
    shrinkWeight: 0,
    baseWidth: '0%'
  },
  [datasetColumnId]: {
    growWeight: 0,
    shrinkWeight: 0,
    baseWidth: '250px'
  },
  [_log_text_stream.iconColumnId]: {
    growWeight: 0,
    shrinkWeight: 0,
    baseWidth: `${DETAIL_FLYOUT_ICON_MIN_WIDTH + 2 * COLUMN_PADDING}px`
  }
};
exports.columnWidths = columnWidths;
const exampleMessageColumnConfigurations = [{
  timestampColumn: {
    id: timestampColumnId
  }
}, {
  messageColumn: {
    id: messageColumnId
  }
}, {
  fieldColumn: {
    field: 'event.dataset',
    id: datasetColumnId
  }
}];
exports.exampleMessageColumnConfigurations = exampleMessageColumnConfigurations;
const LogEntryExampleMessageHeaders = ({
  dateTime
}) => {
  return /*#__PURE__*/_react.default.createElement(LogEntryExampleMessageHeadersWrapper, null, /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, exampleMessageColumnConfigurations.map(columnConfiguration => {
    if ((0, _source_configuration.isTimestampLogColumnConfiguration)(columnConfiguration)) {
      return /*#__PURE__*/_react.default.createElement(_column_headers.LogColumnHeader, {
        key: columnConfiguration.timestampColumn.id,
        columnWidth: columnWidths[columnConfiguration.timestampColumn.id],
        "data-test-subj": "logColumnHeader timestampLogColumnHeader"
      }, (0, _datetime.localizedDate)(dateTime));
    } else if ((0, _source_configuration.isMessageLogColumnConfiguration)(columnConfiguration)) {
      return /*#__PURE__*/_react.default.createElement(_column_headers.LogColumnHeader, {
        columnWidth: columnWidths[columnConfiguration.messageColumn.id],
        "data-test-subj": "logColumnHeader messageLogColumnHeader",
        key: columnConfiguration.messageColumn.id
      }, "Message");
    } else if ((0, _source_configuration.isFieldLogColumnConfiguration)(columnConfiguration)) {
      return /*#__PURE__*/_react.default.createElement(_column_headers.LogColumnHeader, {
        columnWidth: columnWidths[columnConfiguration.fieldColumn.id],
        "data-test-subj": "logColumnHeader fieldLogColumnHeader",
        key: columnConfiguration.fieldColumn.id
      }, columnConfiguration.fieldColumn.field);
    }
  }), /*#__PURE__*/_react.default.createElement(_column_headers.LogColumnHeader, {
    columnWidth: columnWidths[_log_text_stream.iconColumnId],
    "data-test-subj": "logColumnHeader contextMenuLogColumnHeader",
    key: 'icon-column-header'
  }, null)));
};
exports.LogEntryExampleMessageHeaders = LogEntryExampleMessageHeaders;
const LogEntryExampleMessageHeadersWrapper = (0, _common.euiStyled)(_column_headers.LogColumnHeadersWrapper)`
  border-bottom: none;
  box-shadow: none;
  padding-right: 0;
`;