"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.LogEntryRatePageProviders = void 0;
var _react = _interopRequireDefault(require("react"));
var _inline_log_view_splash_page = require("../../../components/logging/inline_log_view_splash_page");
var _setup_flyout = require("../../../components/logging/log_analysis_setup/setup_flyout");
var _source_loading_page = require("../../../components/source_loading_page");
var _log_entry_categories = require("../../../containers/logs/log_analysis/modules/log_entry_categories");
var _log_entry_rate = require("../../../containers/logs/log_analysis/modules/log_entry_rate");
var _log_flyout = require("../../../containers/logs/log_flyout");
var _use_kibana_space = require("../../../hooks/use_kibana_space");
var _use_log_view = require("../../../hooks/use_log_view");
var _page_log_view_error = require("../shared/page_log_view_error");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const LogEntryRatePageProviders = ({
  children
}) => {
  const {
    hasFailedLoading,
    isLoading,
    isUninitialized,
    logViewReference,
    resolvedLogView,
    isPersistedLogView,
    revertToDefaultLogView
  } = (0, _use_log_view.useLogViewContext)();
  const {
    space
  } = (0, _use_kibana_space.useActiveKibanaSpace)();

  // This is a rather crude way of guarding the dependent providers against
  // arguments that are only made available asynchronously. Ideally, we'd use
  // React concurrent mode and Suspense in order to handle that more gracefully.
  if (space == null) {
    return null;
  } else if (!isPersistedLogView) {
    return /*#__PURE__*/_react.default.createElement(_inline_log_view_splash_page.InlineLogViewSplashPage, {
      revertToDefaultLogView: revertToDefaultLogView
    });
  } else if (isLoading || isUninitialized) {
    return /*#__PURE__*/_react.default.createElement(_source_loading_page.SourceLoadingPage, null);
  } else if (hasFailedLoading) {
    return /*#__PURE__*/_react.default.createElement(_page_log_view_error.ConnectedLogViewErrorPage, null);
  } else if (resolvedLogView != null) {
    if (logViewReference.type === 'log-view-inline') {
      throw new Error('Logs ML features only support persisted Log Views');
    }
    return /*#__PURE__*/_react.default.createElement(_log_flyout.LogEntryFlyoutProvider, null, /*#__PURE__*/_react.default.createElement(_log_entry_rate.LogEntryRateModuleProvider, {
      indexPattern: resolvedLogView.indices,
      logViewId: logViewReference.logViewId,
      spaceId: space.id,
      timestampField: resolvedLogView.timestampField,
      runtimeMappings: resolvedLogView.runtimeMappings
    }, /*#__PURE__*/_react.default.createElement(_log_entry_categories.LogEntryCategoriesModuleProvider, {
      indexPattern: resolvedLogView.indices,
      logViewId: logViewReference.logViewId,
      spaceId: space.id,
      timestampField: resolvedLogView.timestampField,
      runtimeMappings: resolvedLogView.runtimeMappings
    }, /*#__PURE__*/_react.default.createElement(_setup_flyout.LogAnalysisSetupFlyoutStateProvider, null, children))));
  } else {
    return null;
  }
};
exports.LogEntryRatePageProviders = LogEntryRatePageProviders;