"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SingleMetricSparkline = void 0;
var _react = _interopRequireWildcard(require("react"));
var _charts = require("@elastic/charts");
var _eui_charts_theme = require("@elastic/eui/dist/eui_charts_theme");
var _use_is_dark_mode = require("../../../../../hooks/use_is_dark_mode");
var _use_kibana_time_zone_setting = require("../../../../../hooks/use_kibana_time_zone_setting");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const timestampAccessor = 'timestamp';
const valueAccessor = ['value'];
const sparklineSize = {
  height: 20,
  width: 100
};
const SingleMetricSparkline = ({
  metric,
  timeRange
}) => {
  const isDarkMode = (0, _use_is_dark_mode.useIsDarkMode)();
  const timeZone = (0, _use_kibana_time_zone_setting.useKibanaTimeZoneSetting)();
  const theme = (0, _react.useMemo)(() => [
  // localThemeOverride,
  _eui_charts_theme.EUI_SPARKLINE_THEME_PARTIAL, isDarkMode ? _eui_charts_theme.EUI_CHARTS_THEME_DARK.theme : _eui_charts_theme.EUI_CHARTS_THEME_LIGHT.theme], [isDarkMode]);
  const xDomain = (0, _react.useMemo)(() => ({
    max: timeRange.endTime,
    min: timeRange.startTime
  }), [timeRange]);
  return /*#__PURE__*/_react.default.createElement(_charts.Chart, {
    size: sparklineSize
  }, /*#__PURE__*/_react.default.createElement(_charts.Tooltip, {
    type: _charts.TooltipType.None
  }), /*#__PURE__*/_react.default.createElement(_charts.Settings, {
    showLegend: false,
    theme: theme,
    xDomain: xDomain
  }), /*#__PURE__*/_react.default.createElement(_charts.AreaSeries, {
    id: "metric",
    data: metric,
    xAccessor: timestampAccessor,
    xScaleType: _charts.ScaleType.Time,
    yAccessors: valueAccessor,
    timeZone: timeZone
  }));
};
exports.SingleMetricSparkline = SingleMetricSparkline;