"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useKibanaHeader = void 0;
var _eui = require("@elastic/eui");
var _react = require("react");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const useKibanaHeader = () => {
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  const headerHeight = (0, _react.useMemo)(() => {
    const wrapper = document.querySelector(`[data-test-subj="kibanaChrome"]`);
    if (!wrapper) {
      return parseInt(euiTheme.size.xxxl, 10) * 2;
    }
    return wrapper.getBoundingClientRect().top;
  }, [euiTheme]);
  return {
    headerHeight
  };
};
exports.useKibanaHeader = useKibanaHeader;