"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.MeasurableItemView = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var React = _interopRequireWildcard(require("react"));
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

class MeasurableItemView extends React.PureComponent {
  constructor(...args) {
    super(...args);
    (0, _defineProperty2.default)(this, "childRef", /*#__PURE__*/React.createRef());
    (0, _defineProperty2.default)(this, "getOffsetRect", () => {
      const currentElement = this.childRef.current;
      if (currentElement === null) {
        return null;
      }
      return {
        height: currentElement.offsetHeight,
        left: currentElement.offsetLeft,
        top: currentElement.offsetTop,
        width: currentElement.offsetWidth
      };
    });
  }
  componentDidMount() {
    this.props.register(this.props.registrationKey, this);
  }
  componentWillUnmount() {
    this.props.register(this.props.registrationKey, null);
  }
  componentDidUpdate(prevProps) {
    if (prevProps.registrationKey !== this.props.registrationKey) {
      this.props.register(prevProps.registrationKey, null);
      this.props.register(this.props.registrationKey, this);
    }
  }
  render() {
    return this.props.children(this.childRef);
  }
}
exports.MeasurableItemView = MeasurableItemView;