"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.LogEntryFieldColumn = void 0;
var _react = _interopRequireDefault(require("react"));
var _common = require("@kbn/kibana-react-plugin/common");
var _log_entry = require("../../../utils/log_entry");
var _field_value = require("./field_value");
var _log_entry_column = require("./log_entry_column");
var _text_styles = require("./text_styles");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const LogEntryFieldColumn = ({
  columnValue,
  highlights: [firstHighlight],
  // we only support one highlight for now
  isActiveHighlight,
  wrapMode,
  render
}) => {
  if ((0, _log_entry.isFieldColumn)(columnValue)) {
    return /*#__PURE__*/_react.default.createElement(FieldColumnContent, {
      wrapMode: wrapMode
    }, /*#__PURE__*/_react.default.createElement(_field_value.FieldValue, {
      highlightTerms: (0, _log_entry.isHighlightFieldColumn)(firstHighlight) ? firstHighlight.highlights : [],
      isActiveHighlight: isActiveHighlight,
      value: columnValue.value,
      render: render
    }));
  } else {
    return null;
  }
};
exports.LogEntryFieldColumn = LogEntryFieldColumn;
const FieldColumnContent = (0, _common.euiStyled)(_log_entry_column.LogEntryColumnContent)`
  text-overflow: ellipsis;

  ${props => props.wrapMode === 'long' ? _text_styles.longWrappedContentStyle : props.wrapMode === 'pre-wrapped' ? _text_styles.preWrappedContentStyle : _text_styles.unwrappedContentStyle};
`;