"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports._SearchMarkerTooltip = exports.SearchMarkerTooltip = void 0;
var _eui = require("@elastic/eui");
var _tool_tip = require("@elastic/eui/lib/components/tool_tip/tool_tip.styles");
var _react = require("@emotion/react");
var React = _interopRequireWildcard(require("react"));
var _auto_sizer = require("../../auto_sizer");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

// @ts-expect-error style types not defined

const POPOVER_ARROW_SIZE = 12; // px, to position it later

class _SearchMarkerTooltip extends React.PureComponent {
  render() {
    const {
      children,
      markerPosition,
      theme
    } = this.props;
    const styles = (0, _tool_tip.euiToolTipStyles)(theme);
    return /*#__PURE__*/React.createElement(_eui.EuiPortal, null, /*#__PURE__*/React.createElement("div", null, /*#__PURE__*/React.createElement(_auto_sizer.AutoSizer, {
      content: false,
      bounds: true
    }, ({
      measureRef,
      bounds: {
        width,
        height
      }
    }) => {
      const {
        top,
        left
      } = width && height ? (0, _eui.calculatePopoverPosition)(markerPosition, {
        width,
        height
      }, 'left', 16, ['left']) : {
        left: -9999,
        // render off-screen before the first measurement
        top: 0
      };
      return /*#__PURE__*/React.createElement("div", {
        css: (0, _react.css)([styles.euiToolTip, styles.left]),
        style: {
          left,
          top
        },
        ref: measureRef
      }, /*#__PURE__*/React.createElement("div", {
        css: (0, _react.css)([styles.euiToolTip__arrow, styles.arrowPositions.left]),
        style: {
          left: width || 0,
          top: (height || 0) / 2 - POPOVER_ARROW_SIZE / 2
        }
      }), /*#__PURE__*/React.createElement("div", null, children));
    })));
  }
}
exports._SearchMarkerTooltip = _SearchMarkerTooltip;
const SearchMarkerTooltip = (0, _eui.withEuiTheme)(_SearchMarkerTooltip);
exports.SearchMarkerTooltip = SearchMarkerTooltip;