"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.RegularExpressionRepresentation = void 0;
var _i18n = require("@kbn/i18n");
var _react = _interopRequireWildcard(require("react"));
var _common = require("@kbn/kibana-react-plugin/common");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const RegularExpressionRepresentation = /*#__PURE__*/(0, _react.memo)(({
  maximumSegmentCount = 30,
  regularExpression
}) => {
  const segments = regularExpression.split(collapsedRegularExpressionCharacters);
  return /*#__PURE__*/_react.default.createElement(CategoryPattern, null, segments.slice(0, maximumSegmentCount).map((segment, segmentIndex) => [segmentIndex > 0 ? /*#__PURE__*/_react.default.createElement(CategoryPatternWildcard, {
    key: `wildcard-${segmentIndex}`
  }, "\u2055") : null, /*#__PURE__*/_react.default.createElement(CategoryPatternSegment, {
    key: `segment-${segmentIndex}`
  }, segment.replace(escapedRegularExpressionCharacters, '$1'))]), segments.length > maximumSegmentCount ? /*#__PURE__*/_react.default.createElement(CategoryPatternWildcard, {
    title: _i18n.i18n.translate('xpack.infra.logs.logEntryCategories.truncatedPatternSegmentDescription', {
      defaultMessage: '{extraSegmentCount, plural, one {one more segment} other {# more segments}}',
      values: {
        extraSegmentCount: segments.length - maximumSegmentCount
      }
    })
  }, "\u2026") : null);
});
exports.RegularExpressionRepresentation = RegularExpressionRepresentation;
const CategoryPattern = _common.euiStyled.span`
  font-family: ${props => props.theme.eui.euiCodeFontFamily};
  word-break: break-all;
`;
const CategoryPatternWildcard = _common.euiStyled.span`
  color: ${props => props.theme.eui.euiColorMediumShade};
`;
const CategoryPatternSegment = _common.euiStyled.span`
  font-weight: bold;
`;
const collapsedRegularExpressionCharacters = /\.[+*]\??/g;
const escapedRegularExpressionCharacters = /\\([\\^$*+?.()\[\]])/g;