"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.createStartServicesAccessorMock = createStartServicesAccessorMock;
var _mocks = require("@kbn/core/public/mocks");
var _i18nReact = require("@kbn/i18n-react");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function createStartServicesAccessorMock(fetchMock) {
  const core = _mocks.coreMock.createStart();
  // @ts-expect-error core.http.fetch has overloads, Jest/TypeScript only picks the first definition when mocking
  core.http.fetch.mockImplementation(fetchMock);
  core.i18n.Context.mockImplementation(_i18nReact.I18nProvider);
  const coreProvidersPropsMock = {
    core,
    pluginStart: {},
    plugins: {},
    theme$: core.theme.theme$
  };
  const getStartServices = () => [coreProvidersPropsMock.core, coreProvidersPropsMock.plugins, coreProvidersPropsMock.pluginStart];
  return {
    coreProvidersPropsMock,
    fetch: core.http.fetch,
    getStartServices
  };
}