"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ChartHeader = void 0;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _common = require("@kbn/kibana-react-plugin/common");
var _color_palette = require("../../../../../common/color_palette");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const ChartHeader = ({
  title,
  metrics
}) => {
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "s",
    responsive: false
  }, /*#__PURE__*/_react.default.createElement(HeaderItem, {
    grow: 1
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "s"
  }, /*#__PURE__*/_react.default.createElement(H4, null, title))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "s",
    alignItems: "center",
    responsive: false
  }, metrics.map(chartMetric => /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    key: chartMetric.label
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    key: chartMetric.label,
    gutterSize: "xs",
    alignItems: "center",
    responsive: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
    color: (0, _color_palette.colorTransformer)(chartMetric.color),
    type: "dot"
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "xs"
  }, chartMetric.label))))))));
};
exports.ChartHeader = ChartHeader;
const HeaderItem = (0, _common.euiStyled)(_eui.EuiFlexItem).attrs({
  grow: 1
})`
  overflow: hidden;
`;
const H4 = (0, _common.euiStyled)('h4')`
  overflow: hidden;
  text-overflow: ellipsis;
  white-space: nowrap;
`;