"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.MetadataEmbeddableFactoryDefinition = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _i18n = require("@kbn/i18n");
var _metadata_embeddable = require("./metadata_embeddable");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

class MetadataEmbeddableFactoryDefinition {
  constructor(getStartServices) {
    (0, _defineProperty2.default)(this, "type", _metadata_embeddable.METADATA_EMBEDDABLE);
    this.getStartServices = getStartServices;
  }
  async isEditable() {
    return false;
  }
  async create(initialInput, parent) {
    const [core, plugins, pluginStart] = await this.getStartServices();
    return new _metadata_embeddable.MetadataEmbeddable(core, plugins, pluginStart, initialInput, parent);
  }
  getDisplayName() {
    return _i18n.i18n.translate('xpack.infra.metadataEmbeddable.displayName', {
      defaultMessage: 'Metadata'
    });
  }
  getDescription() {
    return _i18n.i18n.translate('xpack.infra.metadataEmbeddable.description', {
      defaultMessage: 'Add a table of asset metadata.'
    });
  }
  getIconType() {
    return 'metricsApp';
  }
  async getExplicitInput() {
    return {
      title: _i18n.i18n.translate('xpack.infra.metadataEmbeddable.title', {
        defaultMessage: 'Metadata'
      })
    };
  }
}
exports.MetadataEmbeddableFactoryDefinition = MetadataEmbeddableFactoryDefinition;