"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.MetadataEmbeddable = exports.METADATA_EMBEDDABLE = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _react = _interopRequireDefault(require("react"));
var _reactDom = _interopRequireDefault(require("react-dom"));
var _public = require("@kbn/embeddable-plugin/public");
var _common = require("@kbn/kibana-react-plugin/common");
var _common_providers = require("../../../../apps/common_providers");
var _lazy_metadata_wrapper = require("./lazy_metadata_wrapper");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const METADATA_EMBEDDABLE = 'METADATA_EMBEDDABLE';
exports.METADATA_EMBEDDABLE = METADATA_EMBEDDABLE;
class MetadataEmbeddable extends _public.Embeddable {
  constructor(core, pluginDeps, pluginStart, initialInput, parent) {
    super(initialInput, {}, parent);
    (0, _defineProperty2.default)(this, "type", METADATA_EMBEDDABLE);
    (0, _defineProperty2.default)(this, "node", void 0);
    (0, _defineProperty2.default)(this, "subscription", void 0);
    this.core = core;
    this.pluginDeps = pluginDeps;
    this.pluginStart = pluginStart;
    this.subscription = this.getInput$().subscribe(() => this.renderComponent());
  }
  render(node) {
    if (this.node) {
      _reactDom.default.unmountComponentAtNode(this.node);
    }
    this.node = node;
    this.renderComponent();
  }
  destroy() {
    super.destroy();
    this.subscription.unsubscribe();
    if (this.node) {
      _reactDom.default.unmountComponentAtNode(this.node);
    }
  }
  async reload() {}
  renderComponent() {
    if (!this.node) {
      return;
    }
    _reactDom.default.render( /*#__PURE__*/_react.default.createElement(_common_providers.CoreProviders, {
      core: this.core,
      plugins: this.pluginDeps,
      pluginStart: this.pluginStart,
      theme$: this.core.theme.theme$
    }, /*#__PURE__*/_react.default.createElement(_common.EuiThemeProvider, null, /*#__PURE__*/_react.default.createElement("div", {
      style: {
        width: '100%'
      }
    }, /*#__PURE__*/_react.default.createElement(_lazy_metadata_wrapper.LazyMetadataWrapper, {
      currentTimeRange: this.input.currentTimeRange,
      nodeName: this.input.nodeName,
      nodeType: this.input.nodeType,
      showActionsColumn: this.input.showActionsColumn,
      onSearchChange: this.input.onSearchChange,
      search: this.input.search
    })))), this.node);
  }
}
exports.MetadataEmbeddable = MetadataEmbeddable;