"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.TabToUptime = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _react2 = require("@emotion/react");
var _public = require("@kbn/observability-plugin/public");
var _use_kibana = require("../../../hooks/use_kibana");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const TabToUptime = ({
  nodeType,
  nodeName,
  nodeIp,
  name,
  ...props
}) => {
  const {
    share
  } = (0, _use_kibana.useKibanaContextForPlugin)().services;
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  return /*#__PURE__*/_react.default.createElement(_eui.EuiTab, (0, _extends2.default)({}, props, {
    onClick: () => share.url.locators.get(_public.uptimeOverviewLocatorID).navigate({
      [nodeType]: nodeName,
      ip: nodeIp
    })
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
    type: "popout",
    css: (0, _react2.css)`
          margin-right: ${euiTheme.size.xs};
        `
  }), name);
};
exports.TabToUptime = TabToUptime;