"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.TabSwitcherProvider = exports.TabSwitcher = void 0;
exports.useTabSwitcher = useTabSwitcher;
exports.useTabSwitcherContext = void 0;
var _react = require("react");
var _constate = _interopRequireDefault(require("constate"));
var _use_lazy_ref = require("../../../hooks/use_lazy_ref");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function useTabSwitcher({
  initialActiveTabId
}) {
  const [activeTabId, setActiveTabId] = (0, _react.useState)(initialActiveTabId);

  // This set keeps track of which tabs content have been rendered the first time.
  // We need it in order to load a tab content only if it gets clicked, and then keep it in the DOM for performance improvement.
  const renderedTabsSet = (0, _use_lazy_ref.useLazyRef)(() => new Set([initialActiveTabId]));
  const showTab = tabId => {
    renderedTabsSet.current.add(tabId); // On a tab click, mark the tab content as allowed to be rendered
    setActiveTabId(tabId);
  };
  return {
    activeTabId,
    renderedTabsSet,
    showTab
  };
}
const TabSwitcher = (0, _constate.default)(useTabSwitcher);
exports.TabSwitcher = TabSwitcher;
const [TabSwitcherProvider, useTabSwitcherContext] = TabSwitcher;
exports.useTabSwitcherContext = useTabSwitcherContext;
exports.TabSwitcherProvider = TabSwitcherProvider;