"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.Header = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _react2 = require("@emotion/react");
var _types = require("../types");
var _links = require("../links");
var _use_tab_switcher = require("../hooks/use_tab_switcher");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const APM_FIELD = 'host.hostname';
const Header = ({
  nodeType = 'host',
  node,
  tabs = [],
  links = [],
  compact,
  currentTimeRange,
  overrides,
  onTabsStateChange
}) => {
  var _overrides$alertRule;
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  const {
    showTab,
    activeTabId
  } = (0, _use_tab_switcher.useTabSwitcherContext)();
  const onTabClick = tabId => {
    if (onTabsStateChange) {
      onTabsStateChange({
        activeTabId: tabId
      });
    }
    showTab(tabId);
  };
  const tabLinkComponents = {
    [_types.FlyoutTabIds.LINK_TO_APM]: tab => /*#__PURE__*/_react.default.createElement(_links.TabToApmTraces, (0, _extends2.default)({
      nodeName: node.name,
      apmField: APM_FIELD
    }, tab)),
    [_types.FlyoutTabIds.LINK_TO_UPTIME]: tab => /*#__PURE__*/_react.default.createElement(_links.TabToUptime, (0, _extends2.default)({
      nodeName: node.name,
      nodeType: nodeType,
      nodeIp: node.ip
    }, tab))
  };
  const topCornerLinkComponents = {
    nodeDetails: /*#__PURE__*/_react.default.createElement(_links.LinkToNodeDetails, {
      nodeId: node.id,
      nodeType: nodeType,
      currentTime: currentTimeRange.to
    }),
    alertRule: /*#__PURE__*/_react.default.createElement(_links.LinkToAlertsRule, {
      onClick: overrides === null || overrides === void 0 ? void 0 : (_overrides$alertRule = overrides.alertRule) === null || _overrides$alertRule === void 0 ? void 0 : _overrides$alertRule.onCreateRuleClick
    }),
    apmServices: /*#__PURE__*/_react.default.createElement(_links.LinkToApmServices, {
      nodeName: node.name,
      apmField: APM_FIELD
    }),
    uptime: /*#__PURE__*/_react.default.createElement(_links.LinkToUptime, {
      nodeName: node.name,
      nodeType: nodeType,
      nodeIp: node.ip
    })
  };
  const tabEntries = tabs.map(({
    name,
    ...tab
  }) => {
    if (Object.keys(tabLinkComponents).includes(tab.id)) {
      return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, {
        key: tab.id
      }, tabLinkComponents[tab.id]({
        name,
        ...tab
      }));
    }
    return /*#__PURE__*/_react.default.createElement(_eui.EuiTab, (0, _extends2.default)({}, tab, {
      key: tab.id,
      onClick: () => onTabClick(tab.id),
      isSelected: tab.id === activeTabId
    }), name);
  });
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "m",
    justifyContent: "spaceBetween",
    direction: "row"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: true,
    css: (0, _react2.css)`
            overflow: hidden;
            & h4 {
              text-overflow: ellipsis;
              overflow: hidden;
              white-space: nowrap;
              width: calc(100%);
            }
          `
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: compact ? 'xs' : 'm'
  }, compact ? /*#__PURE__*/_react.default.createElement("h4", null, node.name) : /*#__PURE__*/_react.default.createElement("h1", null, node.name))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    css: (0, _react2.css)`
            align-items: flex-start;
            ${(0, _eui.useEuiMinBreakpoint)('m')} {
              align-items: flex-end;
            }
          `
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "m",
    responsive: false,
    justifyContent: "flexEnd",
    alignItems: "center",
    css: (0, _react2.css)`
              margin-right: ${compact ? euiTheme.size.l : 0};
            `
  }, links === null || links === void 0 ? void 0 : links.map((link, index) => /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    key: index,
    grow: false
  }, topCornerLinkComponents[link]))))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: compact ? 's' : 'l'
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiTabs, {
    bottomBorder: !compact,
    css: (0, _react2.css)`
          margin-bottom: calc(${compact ? '-1 *' : ''} (${euiTheme.size.l} + 1px));
        `,
    size: compact ? 's' : 'l'
  }, tabEntries));
};
exports.Header = Header;