"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.Content = void 0;
var _react = _interopRequireDefault(require("react"));
var _use_tab_switcher = require("../hooks/use_tab_switcher");
var _tabs = require("../tabs");
var _types = require("../types");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const Content = ({
  overrides,
  currentTimeRange,
  node,
  nodeType = 'host',
  onTabsStateChange
}) => {
  var _overrides$anomalies, _overrides$logs, _overrides$logs$logVi, _overrides$logs2, _overrides$logs2$logV, _overrides$logs3, _overrides$metadata, _overrides$metadata2, _overrides$metrics, _overrides$metrics2, _overrides$metrics3, _overrides$processes;
  const onChange = state => {
    if (!onTabsStateChange) {
      return;
    }
    onTabsStateChange(state);
  };
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(TabPanel, {
    activeWhen: _types.FlyoutTabIds.ANOMALIES
  }, /*#__PURE__*/_react.default.createElement(_tabs.Anomalies, {
    nodeName: node.name,
    onClose: overrides === null || overrides === void 0 ? void 0 : (_overrides$anomalies = overrides.anomalies) === null || _overrides$anomalies === void 0 ? void 0 : _overrides$anomalies.onClose
  })), /*#__PURE__*/_react.default.createElement(TabPanel, {
    activeWhen: _types.FlyoutTabIds.LOGS
  }, /*#__PURE__*/_react.default.createElement(_tabs.Logs, {
    nodeName: node.name,
    nodeType: nodeType,
    currentTime: currentTimeRange.to,
    logViewReference: overrides === null || overrides === void 0 ? void 0 : (_overrides$logs = overrides.logs) === null || _overrides$logs === void 0 ? void 0 : (_overrides$logs$logVi = _overrides$logs.logView) === null || _overrides$logs$logVi === void 0 ? void 0 : _overrides$logs$logVi.reference,
    logViewLoading: overrides === null || overrides === void 0 ? void 0 : (_overrides$logs2 = overrides.logs) === null || _overrides$logs2 === void 0 ? void 0 : (_overrides$logs2$logV = _overrides$logs2.logView) === null || _overrides$logs2$logV === void 0 ? void 0 : _overrides$logs2$logV.loading,
    search: overrides === null || overrides === void 0 ? void 0 : (_overrides$logs3 = overrides.logs) === null || _overrides$logs3 === void 0 ? void 0 : _overrides$logs3.query,
    onSearchChange: query => onChange({
      logs: {
        query
      }
    })
  })), /*#__PURE__*/_react.default.createElement(TabPanel, {
    activeWhen: _types.FlyoutTabIds.METADATA
  }, /*#__PURE__*/_react.default.createElement(_tabs.Metadata, {
    currentTimeRange: currentTimeRange,
    nodeName: node.name,
    nodeType: nodeType,
    showActionsColumn: overrides === null || overrides === void 0 ? void 0 : (_overrides$metadata = overrides.metadata) === null || _overrides$metadata === void 0 ? void 0 : _overrides$metadata.showActionsColumn,
    search: overrides === null || overrides === void 0 ? void 0 : (_overrides$metadata2 = overrides.metadata) === null || _overrides$metadata2 === void 0 ? void 0 : _overrides$metadata2.query,
    onSearchChange: query => onChange({
      metadata: {
        query
      }
    })
  })), /*#__PURE__*/_react.default.createElement(TabPanel, {
    activeWhen: _types.FlyoutTabIds.METRICS
  }, /*#__PURE__*/_react.default.createElement(_tabs.Metrics, {
    currentTime: currentTimeRange.to,
    accountId: overrides === null || overrides === void 0 ? void 0 : (_overrides$metrics = overrides.metrics) === null || _overrides$metrics === void 0 ? void 0 : _overrides$metrics.accountId,
    customMetrics: overrides === null || overrides === void 0 ? void 0 : (_overrides$metrics2 = overrides.metrics) === null || _overrides$metrics2 === void 0 ? void 0 : _overrides$metrics2.customMetrics,
    region: overrides === null || overrides === void 0 ? void 0 : (_overrides$metrics3 = overrides.metrics) === null || _overrides$metrics3 === void 0 ? void 0 : _overrides$metrics3.region,
    nodeId: node.id,
    nodeType: nodeType
  })), /*#__PURE__*/_react.default.createElement(TabPanel, {
    activeWhen: _types.FlyoutTabIds.OSQUERY
  }, /*#__PURE__*/_react.default.createElement(_tabs.Osquery, {
    nodeName: node.name,
    nodeType: nodeType,
    currentTimeRange: currentTimeRange
  })), /*#__PURE__*/_react.default.createElement(TabPanel, {
    activeWhen: _types.FlyoutTabIds.PROCESSES
  }, /*#__PURE__*/_react.default.createElement(_tabs.Processes, {
    nodeName: node.name,
    nodeType: nodeType,
    currentTime: currentTimeRange.to,
    search: overrides === null || overrides === void 0 ? void 0 : (_overrides$processes = overrides.processes) === null || _overrides$processes === void 0 ? void 0 : _overrides$processes.query,
    onSearchFilterChange: query => onChange({
      processes: {
        query
      }
    })
  })));
};
exports.Content = Content;
const TabPanel = ({
  activeWhen,
  children
}) => {
  const {
    renderedTabsSet,
    activeTabId
  } = (0, _use_tab_switcher.useTabSwitcherContext)();
  return renderedTabsSet.current.has(activeWhen) ? /*#__PURE__*/_react.default.createElement("div", {
    hidden: activeTabId !== activeWhen
  }, children) : null;
};