"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.diskWriteThroughput = void 0;
var _utils = require("./utils");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const diskWriteThroughput = {
  title: 'Disk Write Throughput',
  formula: {
    formula: "counter_rate(max(system.diskio.write.count), kql='system.diskio.write.count: *')",
    format: {
      id: 'bytes',
      params: {
        decimals: 1
      }
    }
  },
  getFilters: _utils.getFilters
};
exports.diskWriteThroughput = diskWriteThroughput;