"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.DataViewCache = exports.DEFAULT_AD_HOC_DATA_VIEW_ID = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const DEFAULT_AD_HOC_DATA_VIEW_ID = 'infra_lens_ad_hoc_default';
exports.DEFAULT_AD_HOC_DATA_VIEW_ID = DEFAULT_AD_HOC_DATA_VIEW_ID;
class DataViewCache {
  constructor(capacity) {
    (0, _defineProperty2.default)(this, "cache", new Map());
    (0, _defineProperty2.default)(this, "capacity", void 0);
    this.capacity = capacity;
    this.cache = new Map();
  }
  static getInstance(capacity = 10) {
    if (!DataViewCache.instance) {
      DataViewCache.instance = new DataViewCache(capacity);
    }
    return DataViewCache.instance;
  }
  getSpec(dataView) {
    var _dataView$id;
    const key = (_dataView$id = dataView.id) !== null && _dataView$id !== void 0 ? _dataView$id : DEFAULT_AD_HOC_DATA_VIEW_ID;
    const spec = this.cache.get(key);
    if (!spec) {
      const result = dataView.toSpec();
      this.setSpec(key, result);
      return result;
    }
    return spec;
  }
  setSpec(key, value) {
    if (this.cache.size >= this.capacity) {
      const lruKey = this.cache.keys().next().value;
      this.cache.delete(lruKey);
    }
    this.cache.set(key, value);
  }
}
exports.DataViewCache = DataViewCache;
(0, _defineProperty2.default)(DataViewCache, "instance", void 0);