"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.CoreProviders = exports.CommonInfraProviders = void 0;
var _react = _interopRequireDefault(require("react"));
var _common = require("@kbn/kibana-react-plugin/common");
var _public = require("@kbn/kibana-react-plugin/public");
var _public2 = require("@kbn/observability-plugin/public");
var _public3 = require("@kbn/observability-shared-plugin/public");
var _use_kibana = require("../hooks/use_kibana");
var _header_action_menu_provider = require("../utils/header_action_menu_provider");
var _triggers_actions_context = require("../utils/triggers_actions_context");
var _use_is_dark_mode = require("../hooks/use_is_dark_mode");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const CommonInfraProviders = ({
  children,
  triggersActionsUI,
  observabilityCopilot,
  setHeaderActionMenu,
  appName,
  storage,
  theme$
}) => {
  const darkMode = (0, _use_is_dark_mode.useIsDarkMode)();
  return /*#__PURE__*/_react.default.createElement(_triggers_actions_context.TriggersActionsProvider, {
    triggersActionsUI: triggersActionsUI
  }, /*#__PURE__*/_react.default.createElement(_common.EuiThemeProvider, {
    darkMode: darkMode
  }, /*#__PURE__*/_react.default.createElement(DataUIProviders, {
    appName: appName,
    storage: storage
  }, /*#__PURE__*/_react.default.createElement(_public2.CoPilotContextProvider, {
    value: observabilityCopilot
  }, /*#__PURE__*/_react.default.createElement(_header_action_menu_provider.HeaderActionMenuProvider, {
    setHeaderActionMenu: setHeaderActionMenu,
    theme$: theme$
  }, /*#__PURE__*/_react.default.createElement(_public3.NavigationWarningPromptProvider, null, children))))));
};
exports.CommonInfraProviders = CommonInfraProviders;
const CoreProviders = ({
  children,
  core,
  pluginStart,
  plugins,
  theme$
}) => {
  const KibanaContextProviderForPlugin = (0, _use_kibana.useKibanaContextForPluginProvider)(core, plugins, pluginStart);
  return /*#__PURE__*/_react.default.createElement(KibanaContextProviderForPlugin, {
    services: {
      ...core,
      ...plugins,
      ...pluginStart
    }
  }, /*#__PURE__*/_react.default.createElement(core.i18n.Context, null, /*#__PURE__*/_react.default.createElement(_public.KibanaThemeProvider, {
    theme$: theme$
  }, children)));
};
exports.CoreProviders = CoreProviders;
const DataUIProviders = ({
  appName,
  children,
  storage
}) => /*#__PURE__*/_react.default.createElement(_public.KibanaContextProvider, {
  services: {
    appName,
    storage
  }
}, children);