"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SeverityThresholdExpression = exports.ClosablePopoverTitle = void 0;
var _react = _interopRequireWildcard(require("react"));
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _eui = require("@elastic/eui");
var _anomaly_threshold = require("@kbn/ml-anomaly-utils/anomaly_threshold");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const options = {
  [_anomaly_threshold.ML_ANOMALY_THRESHOLD.CRITICAL]: {
    text: _i18n.i18n.translate('xpack.infra.metrics.alertFlyout.expression.severityScore.criticalLabel', {
      defaultMessage: 'Critical'
    }),
    value: _anomaly_threshold.ML_ANOMALY_THRESHOLD.CRITICAL
  },
  [_anomaly_threshold.ML_ANOMALY_THRESHOLD.MAJOR]: {
    text: _i18n.i18n.translate('xpack.infra.metrics.alertFlyout.expression.severityScore.majorLabel', {
      defaultMessage: 'Major'
    }),
    value: _anomaly_threshold.ML_ANOMALY_THRESHOLD.MAJOR
  },
  [_anomaly_threshold.ML_ANOMALY_THRESHOLD.MINOR]: {
    text: _i18n.i18n.translate('xpack.infra.metrics.alertFlyout.expression.severityScore.minorLabel', {
      defaultMessage: 'Minor'
    }),
    value: _anomaly_threshold.ML_ANOMALY_THRESHOLD.MINOR
  },
  [_anomaly_threshold.ML_ANOMALY_THRESHOLD.WARNING]: {
    text: _i18n.i18n.translate('xpack.infra.metrics.alertFlyout.expression.severityScore.warningLabel', {
      defaultMessage: 'Warning'
    }),
    value: _anomaly_threshold.ML_ANOMALY_THRESHOLD.WARNING
  }
};
const SeverityThresholdExpression = ({
  value,
  onChange,
  popupPosition
}) => {
  const [aggTypePopoverOpen, setAggTypePopoverOpen] = (0, _react.useState)(false);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiPopover, {
    button: /*#__PURE__*/_react.default.createElement(_eui.EuiExpression, {
      "data-test-subj": "nodeTypeExpression",
      description: _i18n.i18n.translate('xpack.infra.metrics.alertFlyout.expression.severityScore.descriptionLabel', {
        defaultMessage: 'Severity score is above'
      }),
      value: options[value].text,
      isActive: aggTypePopoverOpen,
      onClick: () => {
        setAggTypePopoverOpen(true);
      }
    }),
    isOpen: aggTypePopoverOpen,
    closePopover: () => {
      setAggTypePopoverOpen(false);
    },
    ownFocus: true,
    anchorPosition: popupPosition !== null && popupPosition !== void 0 ? popupPosition : 'downLeft'
  }, /*#__PURE__*/_react.default.createElement("div", null, /*#__PURE__*/_react.default.createElement(ClosablePopoverTitle, {
    onClose: () => setAggTypePopoverOpen(false)
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.infra.metrics.alertFlyout.expression.severityScore.popoverTitle",
    defaultMessage: "Severity Score"
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiSelect, {
    "data-test-subj": "severityExpressionSelect",
    value: value,
    fullWidth: true,
    onChange: e => {
      onChange(Number(e.target.value));
      setAggTypePopoverOpen(false);
    },
    options: Object.values(options).map(o => o)
  })));
};
exports.SeverityThresholdExpression = SeverityThresholdExpression;
const ClosablePopoverTitle = ({
  children,
  onClose
}) => {
  return /*#__PURE__*/_react.default.createElement(_eui.EuiPopoverTitle, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    alignItems: "center",
    gutterSize: "s"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, children), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, {
    iconType: "cross",
    color: "danger",
    "aria-label": _i18n.i18n.translate('xpack.infra.metrics.expressionItems.components.closablePopoverTitle.closeLabel', {
      defaultMessage: 'Close'
    }),
    onClick: () => onClose()
  }))));
};
exports.ClosablePopoverTitle = ClosablePopoverTitle;