"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ExplainLogRateSpikes = void 0;
var _react = _interopRequireWildcard(require("react"));
var _lodash = require("lodash");
var _moment = _interopRequireDefault(require("moment"));
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _public = require("@kbn/aiops-plugin/public");
var _public2 = require("@kbn/observability-plugin/public");
var _i18n = require("@kbn/i18n");
var _common = require("@kbn/observability-plugin/common");
var _ruleDataUtils = require("@kbn/rule-data-utils");
var _color_palette = require("../../../../../../common/color_palette");
var _use_kibana = require("../../../../../hooks/use_kibana");
var _log_threshold = require("../../../../../../common/alerting/logs/log_threshold");
var _runtime_types = require("../../../../../../common/runtime_types");
var _log_rate_spike_query = require("../log_rate_spike_query");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const ExplainLogRateSpikes = ({
  rule,
  alert
}) => {
  var _logSpikeParams$signi;
  const {
    services
  } = (0, _use_kibana.useKibanaContextForPlugin)();
  const {
    dataViews,
    logViews
  } = services;
  const [dataView, setDataView] = (0, _react.useState)();
  const [esSearchQuery, setEsSearchQuery] = (0, _react.useState)();
  const [logSpikeParams, setLogSpikeParams] = (0, _react.useState)();
  (0, _react.useEffect)(() => {
    const getDataView = async () => {
      const {
        timestampField,
        dataViewReference
      } = await logViews.client.getResolvedLogView(rule.params.logView);
      if (dataViewReference.id) {
        const logDataView = await dataViews.get(dataViewReference.id);
        setDataView(logDataView);
        getQuery(timestampField);
      }
    };
    const getQuery = timestampField => {
      const esSearchRequest = (0, _log_rate_spike_query.getESQueryForLogSpike)(validatedParams, timestampField, alert, rule.params.groupBy);
      if (esSearchRequest) {
        setEsSearchQuery(esSearchRequest);
      }
    };
    const validatedParams = (0, _runtime_types.decodeOrThrow)(_log_threshold.ruleParamsRT)(rule.params);
    if (!(0, _log_threshold.isRatioRuleParams)(validatedParams) && (validatedParams.count.comparator === _log_threshold.Comparator.GT || validatedParams.count.comparator === _log_threshold.Comparator.GT_OR_EQ)) {
      getDataView();
    }
  }, [rule, alert, dataViews, logViews]);

  // Identify `intervalFactor` to adjust time ranges based on alert settings.
  // The default time ranges for `initialAnalysisStart` are suitable for a `1m` lookback.
  // If an alert would have a `5m` lookback, this would result in a factor of `5`.
  const lookbackDuration = alert.fields['kibana.alert.rule.parameters'] && alert.fields['kibana.alert.rule.parameters'].timeSize && alert.fields['kibana.alert.rule.parameters'].timeUnit ? _moment.default.duration(alert.fields['kibana.alert.rule.parameters'].timeSize, alert.fields['kibana.alert.rule.parameters'].timeUnit) : _moment.default.duration(1, 'm');
  const intervalFactor = Math.max(1, lookbackDuration.asSeconds() / 60);
  const alertStart = (0, _moment.default)(alert.start);
  const alertEnd = alert.fields[_ruleDataUtils.ALERT_END] ? (0, _moment.default)(alert.fields[_ruleDataUtils.ALERT_END]) : undefined;
  const timeRange = {
    min: alertStart.clone().subtract(15 * intervalFactor, 'minutes'),
    max: alertEnd ? alertEnd.clone().add(1 * intervalFactor, 'minutes') : (0, _moment.default)(new Date())
  };
  function getDeviationMax() {
    if (alertEnd) {
      return alertEnd.clone().subtract(1 * intervalFactor, 'minutes').valueOf();
    } else if (alertStart.clone().add(10 * intervalFactor, 'minutes').isAfter((0, _moment.default)(new Date()))) {
      return (0, _moment.default)(new Date()).valueOf();
    } else {
      return alertStart.clone().add(10 * intervalFactor, 'minutes').valueOf();
    }
  }
  const initialAnalysisStart = {
    baselineMin: alertStart.clone().subtract(13 * intervalFactor, 'minutes').valueOf(),
    baselineMax: alertStart.clone().subtract(2 * intervalFactor, 'minutes').valueOf(),
    deviationMin: alertStart.clone().subtract(1 * intervalFactor, 'minutes').valueOf(),
    deviationMax: getDeviationMax()
  };
  const explainLogSpikeTitle = _i18n.i18n.translate('xpack.infra.logs.alertDetails.explainLogSpikeTitle', {
    defaultMessage: 'Possible causes and remediations'
  });
  const onAnalysisCompleted = analysisResults => {
    var _analysisResults$sign;
    const significantFieldValues = (0, _lodash.orderBy)(analysisResults === null || analysisResults === void 0 ? void 0 : (_analysisResults$sign = analysisResults.significantTerms) === null || _analysisResults$sign === void 0 ? void 0 : _analysisResults$sign.map(item => ({
      field: item.fieldName,
      value: item.fieldValue,
      docCount: item.doc_count,
      pValue: item.pValue
    })), ['pValue', 'docCount'], ['asc', 'asc']).slice(0, 50);
    setLogSpikeParams(significantFieldValues ? {
      significantFieldValues
    } : undefined);
  };
  const coPilotService = (0, _public2.useCoPilot)();
  const hasLogSpikeParams = logSpikeParams && ((_logSpikeParams$signi = logSpikeParams.significantFieldValues) === null || _logSpikeParams$signi === void 0 ? void 0 : _logSpikeParams$signi.length) > 0;
  if (!dataView || !esSearchQuery) return null;
  return /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    hasBorder: true,
    "data-test-subj": "explainLogRateSpikesAlertDetails"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column",
    gutterSize: "none",
    responsive: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "xs"
  }, /*#__PURE__*/_react.default.createElement("h2", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.infra.logs.alertDetails.explainLogRateSpikes.sectionTitle",
    defaultMessage: "Explain Log Rate Spikes"
  })))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_public.ExplainLogRateSpikesContent, {
    dataView: dataView,
    timeRange: timeRange,
    esSearchQuery: esSearchQuery,
    initialAnalysisStart: initialAnalysisStart,
    barColorOverride: (0, _color_palette.colorTransformer)(_color_palette.Color.color0),
    barHighlightColorOverride: (0, _color_palette.colorTransformer)(_color_palette.Color.color1),
    onAnalysisCompleted: onAnalysisCompleted,
    appDependencies: (0, _lodash.pick)(services, ['application', 'data', 'executionContext', 'charts', 'fieldFormats', 'http', 'notifications', 'share', 'storage', 'uiSettings', 'unifiedSearch', 'theme', 'lens'])
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column",
    gutterSize: "m"
  }, coPilotService !== null && coPilotService !== void 0 && coPilotService.isEnabled() && hasLogSpikeParams ? /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_public2.CoPilotPrompt, {
    coPilot: coPilotService,
    title: explainLogSpikeTitle,
    params: logSpikeParams,
    promptId: _common.CoPilotPromptId.ExplainLogSpike,
    feedbackEnabled: false
  })) : null));
};
exports.ExplainLogRateSpikes = ExplainLogRateSpikes;