"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.yAxisFormatter = exports.useDateFormatter = exports.tooltipProps = exports.getDomain = exports.TIME_LABELS = exports.NoDataState = exports.NUM_BUCKETS = exports.LoadingState = exports.ErrorState = exports.EmptyContainer = exports.ChartContainer = void 0;
var _react = _interopRequireWildcard(require("react"));
var _charts = require("@elastic/charts");
var _moment = _interopRequireDefault(require("moment"));
var _i18n = require("@kbn/i18n");
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _lodash = require("lodash");
var _number = require("../../../../common/formatters/number");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const tooltipProps = {
  headerFormatter: ({
    value
  }) => (0, _moment.default)(value).format('Y-MM-DD HH:mm:ss')
};
exports.tooltipProps = tooltipProps;
const NUM_BUCKETS = 20;
exports.NUM_BUCKETS = NUM_BUCKETS;
const TIME_LABELS = {
  s: _i18n.i18n.translate('xpack.infra.alerts.timeLabels.seconds', {
    defaultMessage: 'seconds'
  }),
  m: _i18n.i18n.translate('xpack.infra.alerts.timeLabels.minutes', {
    defaultMessage: 'minutes'
  }),
  h: _i18n.i18n.translate('xpack.infra.alerts.timeLabels.hours', {
    defaultMessage: 'hours'
  }),
  d: _i18n.i18n.translate('xpack.infra.alerts.timeLabels.days', {
    defaultMessage: 'days'
  })
};
exports.TIME_LABELS = TIME_LABELS;
const useDateFormatter = (xMin, xMax) => {
  const dateFormatter = (0, _react.useMemo)(() => {
    if (typeof xMin === 'number' && typeof xMax === 'number') {
      return (0, _charts.niceTimeFormatter)([xMin, xMax]);
    } else {
      return value => `${value}`;
    }
  }, [xMin, xMax]);
  return dateFormatter;
};
exports.useDateFormatter = useDateFormatter;
const yAxisFormatter = _number.formatNumber;
exports.yAxisFormatter = yAxisFormatter;
const getDomain = (series, stacked = false) => {
  let min = null;
  let max = null;
  const valuesByTimestamp = series.reduce((acc, serie) => {
    serie.points.forEach(point => {
      const valuesForTimestamp = acc[point.timestamp] || [];
      acc[point.timestamp] = [...valuesForTimestamp, point.value];
    });
    return acc;
  }, {});
  const pointValues = Object.values(valuesByTimestamp);
  pointValues.forEach(results => {
    const maxResult = stacked ? (0, _lodash.sum)(results) : (0, _lodash.max)(results);
    const minResult = (0, _lodash.min)(results);
    if (maxResult && (!max || maxResult > max)) {
      max = maxResult;
    }
    if (minResult && (!min || minResult < min)) {
      min = minResult;
    }
  });
  const timestampValues = Object.keys(valuesByTimestamp).map(Number);
  const minTimestamp = (0, _lodash.min)(timestampValues) || 0;
  const maxTimestamp = (0, _lodash.max)(timestampValues) || 0;
  return {
    yMin: min || 0,
    yMax: max || 0,
    xMin: minTimestamp,
    xMax: maxTimestamp
  };
};
exports.getDomain = getDomain;
const EmptyContainer = ({
  children
}) => /*#__PURE__*/_react.default.createElement("div", {
  style: {
    width: '100%',
    height: 150,
    display: 'flex',
    justifyContent: 'center',
    alignItems: 'center'
  }
}, children);
exports.EmptyContainer = EmptyContainer;
const ChartContainer = ({
  children
}) => /*#__PURE__*/_react.default.createElement("div", {
  style: {
    width: '100%',
    height: 150
  }
}, children);
exports.ChartContainer = ChartContainer;
const NoDataState = () => {
  return /*#__PURE__*/_react.default.createElement(EmptyContainer, null, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    color: "subdued",
    "data-test-subj": "noChartData"
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.infra.alerts.charts.noDataMessage",
    defaultMessage: "No chart data available"
  })));
};
exports.NoDataState = NoDataState;
const LoadingState = () => {
  return /*#__PURE__*/_react.default.createElement(EmptyContainer, null, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    color: "subdued",
    "data-test-subj": "loadingData"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiLoadingChart, {
    size: "m"
  })));
};
exports.LoadingState = LoadingState;
const ErrorState = () => {
  return /*#__PURE__*/_react.default.createElement(EmptyContainer, null, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    color: "subdued",
    "data-test-subj": "chartErrorState"
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.infra.alerts.charts.errorMessage",
    defaultMessage: "Uh oh, something went wrong"
  })));
};
exports.ErrorState = ErrorState;