"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.RangeRT = exports.InfraMetricTypeRT = exports.InfraAssetMetricsRT = exports.InfraAssetMetricsItemRT = exports.InfraAssetMetadataTypeRT = exports.InfraAssetMetadataRT = exports.GetInfraMetricsResponsePayloadRT = exports.GetInfraMetricsRequestBodyPayloadRT = void 0;
var _ioTsUtils = require("@kbn/io-ts-utils");
var rt = _interopRequireWildcard(require("io-ts"));
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const InfraMetricTypeRT = rt.keyof({
  cpu: null,
  normalizedLoad1m: null,
  diskSpaceUsage: null,
  memory: null,
  memoryFree: null,
  rx: null,
  tx: null
});
exports.InfraMetricTypeRT = InfraMetricTypeRT;
const RangeRT = rt.type({
  from: _ioTsUtils.dateRt,
  to: _ioTsUtils.dateRt
});
exports.RangeRT = RangeRT;
const InfraAssetMetadataTypeRT = rt.keyof({
  'cloud.provider': null,
  'host.ip': null,
  'host.os.name': null
});
exports.InfraAssetMetadataTypeRT = InfraAssetMetadataTypeRT;
const InfraAssetMetricsRT = rt.type({
  name: InfraMetricTypeRT,
  value: rt.union([rt.number, rt.null])
});
exports.InfraAssetMetricsRT = InfraAssetMetricsRT;
const InfraAssetMetadataRT = rt.type({
  // keep the actual field name from the index mappings
  name: InfraAssetMetadataTypeRT,
  value: rt.union([rt.string, rt.null])
});
exports.InfraAssetMetadataRT = InfraAssetMetadataRT;
const GetInfraMetricsRequestBodyPayloadRT = rt.intersection([rt.partial({
  query: rt.UnknownRecord
}), rt.type({
  type: rt.literal('host'),
  limit: rt.union([(0, _ioTsUtils.inRangeRt)(1, 500), (0, _ioTsUtils.createLiteralValueFromUndefinedRT)(20)]),
  metrics: rt.array(rt.type({
    type: InfraMetricTypeRT
  })),
  sourceId: rt.string,
  range: RangeRT
})]);
exports.GetInfraMetricsRequestBodyPayloadRT = GetInfraMetricsRequestBodyPayloadRT;
const InfraAssetMetricsItemRT = rt.type({
  name: rt.string,
  metrics: rt.array(InfraAssetMetricsRT),
  metadata: rt.array(InfraAssetMetadataRT)
});
exports.InfraAssetMetricsItemRT = InfraAssetMetricsItemRT;
const GetInfraMetricsResponsePayloadRT = rt.type({
  type: rt.literal('host'),
  nodes: rt.array(InfraAssetMetricsItemRT)
});
exports.GetInfraMetricsResponsePayloadRT = GetInfraMetricsResponsePayloadRT;