"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getDetailPanelReducer = void 0;
var _reduxActions = require("redux-actions");
var _constants = require("../../../../common/constants");
var _constants2 = require("../../constants");
var _detail_panel = require("../actions/detail_panel");
var _load_index_data = require("../actions/load_index_data");
var _update_index_settings = require("../actions/update_index_settings");
var _delete_indices = require("../actions/delete_indices");
var _analytics = require("@kbn/analytics");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const defaultState = {};
const getDetailPanelReducer = uiMetricService => (0, _reduxActions.handleActions)({
  [_delete_indices.deleteIndicesSuccess](state, action) {
    const {
      indexNames
    } = action.payload;
    const {
      indexName
    } = state;
    if (indexNames.includes(indexName)) {
      return {};
    } else {
      return state;
    }
  },
  [_detail_panel.openDetailPanel](state, action) {
    const {
      panelType,
      indexName,
      title
    } = action.payload;
    const panelTypeToUiMetricMap = {
      [_constants2.TAB_SUMMARY]: _constants.UIM_DETAIL_PANEL_SUMMARY_TAB,
      [_constants2.TAB_SETTINGS]: _constants.UIM_DETAIL_PANEL_SETTINGS_TAB,
      [_constants2.TAB_MAPPING]: _constants.UIM_DETAIL_PANEL_MAPPING_TAB,
      [_constants2.TAB_STATS]: _constants.UIM_DETAIL_PANEL_STATS_TAB,
      [_constants2.TAB_EDIT_SETTINGS]: _constants.UIM_DETAIL_PANEL_EDIT_SETTINGS_TAB
    };
    if (panelTypeToUiMetricMap[panelType]) {
      uiMetricService.trackMetric(_analytics.METRIC_TYPE.COUNT, panelTypeToUiMetricMap[panelType]);
    }
    return {
      panelType: panelType || state.panelType || _constants2.TAB_SUMMARY,
      indexName,
      title
    };
  },
  [_detail_panel.closeDetailPanel]() {
    return {};
  },
  [_load_index_data.loadIndexDataSuccess](state, action) {
    const {
      data
    } = action.payload;
    const newState = {
      ...state,
      data
    };
    return newState;
  },
  [_update_index_settings.updateIndexSettingsError](state, action) {
    const {
      error
    } = action.payload;
    const newState = {
      ...state,
      error
    };
    return newState;
  },
  [_update_index_settings.updateIndexSettingsSuccess]() {
    return {};
  }
}, defaultState);
exports.getDetailPanelReducer = getDetailPanelReducer;