"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.loadIndexDataSuccess = exports.loadIndexData = void 0;
var _reduxActions = require("redux-actions");
var _services = require("../../services");
var _notification = require("../../services/notification");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const loadIndexDataSuccess = (0, _reduxActions.createAction)('INDEX_MANAGEMENT_LOAD_INDEX_DATA_SUCCESS');
exports.loadIndexDataSuccess = loadIndexDataSuccess;
const loadIndexData = ({
  indexName,
  dataType
}) => async dispatch => {
  let data;
  try {
    data = await (0, _services.loadIndexData)(dataType, indexName);
  } catch (error) {
    _notification.notificationService.showDangerToast(error.message);
  }
  dispatch(loadIndexDataSuccess({
    data,
    indexName
  }));
};
exports.loadIndexData = loadIndexData;