"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.homeSections = exports.Section = exports.IndexManagementHome = void 0;
var _react = _interopRequireWildcard(require("react"));
var _reactRouterDom = require("react-router-dom");
var _sharedUxRouter = require("@kbn/shared-ux-router");
var _i18nReact = require("@kbn/i18n-react");
var _eui = require("@elastic/eui");
var _documentation = require("../../services/documentation");
var _data_stream_list = require("./data_stream_list");
var _index_list = require("./index_list");
var _template_list = require("./template_list");
var _component_templates = require("../../components/component_templates");
var _breadcrumbs = require("../../services/breadcrumbs");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
let Section;
exports.Section = Section;
(function (Section) {
  Section["Indices"] = "indices";
  Section["DataStreams"] = "data_streams";
  Section["IndexTemplates"] = "templates";
  Section["ComponentTemplates"] = "component_templates";
})(Section || (exports.Section = Section = {}));
const homeSections = [Section.Indices, Section.DataStreams, Section.IndexTemplates, Section.ComponentTemplates];
exports.homeSections = homeSections;
const IndexManagementHome = ({
  match: {
    params: {
      section
    }
  },
  history
}) => {
  const tabs = [{
    id: Section.Indices,
    name: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.idxMgmt.home.indicesTabTitle",
      defaultMessage: "Indices"
    })
  }, {
    id: Section.DataStreams,
    name: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.idxMgmt.home.dataStreamsTabTitle",
      defaultMessage: "Data Streams"
    })
  }, {
    id: Section.IndexTemplates,
    name: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.idxMgmt.home.indexTemplatesTabTitle",
      defaultMessage: "Index Templates"
    })
  }, {
    id: Section.ComponentTemplates,
    name: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.idxMgmt.home.componentTemplatesTabTitle",
      defaultMessage: "Component Templates"
    })
  }];
  const onSectionChange = newSection => {
    history.push(`/${newSection}`);
  };
  (0, _react.useEffect)(() => {
    _breadcrumbs.breadcrumbService.setBreadcrumbs('home');
  }, []);
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiPageHeader, {
    "data-test-subj": "indexManagementHeaderContent",
    pageTitle: /*#__PURE__*/_react.default.createElement("span", {
      "data-test-subj": "appTitle"
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.idxMgmt.home.appTitle",
      defaultMessage: "Index Management"
    })),
    bottomBorder: true,
    rightSideItems: [/*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
      href: _documentation.documentationService.getIdxMgmtDocumentationLink(),
      target: "_blank",
      iconType: "help",
      "data-test-subj": "documentationLink"
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.idxMgmt.home.idxMgmtDocsLinkText",
      defaultMessage: "Index Management docs"
    }))],
    tabs: tabs.map(tab => ({
      onClick: () => onSectionChange(tab.id),
      isSelected: tab.id === section,
      key: tab.id,
      'data-test-subj': `${tab.id}Tab`,
      label: tab.name
    }))
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "l"
  }), /*#__PURE__*/_react.default.createElement(_reactRouterDom.Switch, null, /*#__PURE__*/_react.default.createElement(_sharedUxRouter.Route, {
    exact: true,
    path: [`/${Section.DataStreams}`, `/${Section.DataStreams}/:dataStreamName?`],
    component: _data_stream_list.DataStreamList
  }), /*#__PURE__*/_react.default.createElement(_sharedUxRouter.Route, {
    exact: true,
    path: `/${Section.Indices}`,
    component: _index_list.IndexList
  }), /*#__PURE__*/_react.default.createElement(_sharedUxRouter.Route, {
    exact: true,
    path: [`/${Section.IndexTemplates}`, `/${Section.IndexTemplates}/:templateName?`],
    component: _template_list.TemplateList
  }), /*#__PURE__*/_react.default.createElement(_sharedUxRouter.Route, {
    exact: true,
    path: [`/${Section.ComponentTemplates}`, `/${Section.ComponentTemplates}/:componentTemplateName?`],
    component: _component_templates.ComponentTemplateList
  })));
};
exports.IndexManagementHome = IndexManagementHome;